/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flagd.resolver.process;

import dev.openfeature.contrib.providers.flagd.FlagdOptions;
import dev.openfeature.contrib.providers.flagd.resolver.Resolver;
import dev.openfeature.contrib.providers.flagd.resolver.common.ConnectionEvent;
import dev.openfeature.contrib.providers.flagd.resolver.common.Util;
import dev.openfeature.contrib.providers.flagd.resolver.process.model.FeatureFlag;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.FlagStore;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.Storage;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.StorageStateChange;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.Connector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.file.FileConnector;
import dev.openfeature.contrib.providers.flagd.resolver.process.storage.connector.grpc.GrpcStreamConnector;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.Operator;
import dev.openfeature.contrib.providers.flagd.resolver.process.targeting.TargetingRuleException;
import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ParseError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessResolver
implements Resolver {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InProcessResolver.class);
    private final Storage flagStore;
    private final Consumer<ConnectionEvent> onConnectionEvent;
    private final Operator operator;
    private final long deadline;
    private final ImmutableMetadata metadata;
    private final Supplier<Boolean> connectedSupplier;

    public InProcessResolver(FlagdOptions options, Supplier<Boolean> connectedSupplier, Consumer<ConnectionEvent> onConnectionEvent) {
        this.flagStore = new FlagStore(InProcessResolver.getConnector(options));
        this.deadline = options.getDeadline();
        this.onConnectionEvent = onConnectionEvent;
        this.operator = new Operator();
        this.connectedSupplier = connectedSupplier;
        this.metadata = options.getSelector() == null ? null : ImmutableMetadata.builder().addString("scope", options.getSelector()).build();
    }

    @Override
    public void init() throws Exception {
        this.flagStore.init();
        Thread stateWatcher = new Thread(() -> {
            try {
                block6: while (true) {
                    StorageStateChange storageStateChange = this.flagStore.getStateQueue().take();
                    switch (storageStateChange.getStorageState()) {
                        case OK: {
                            this.onConnectionEvent.accept(new ConnectionEvent(true, storageStateChange.getChangedFlagsKeys(), storageStateChange.getSyncMetadata()));
                            continue block6;
                        }
                        case ERROR: {
                            this.onConnectionEvent.accept(new ConnectionEvent(false));
                            continue block6;
                        }
                    }
                    log.info(String.format("Storage emitted unhandled status: %s", new Object[]{storageStateChange.getStorageState()}));
                }
            }
            catch (InterruptedException e) {
                log.warn("Storage state watcher interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        });
        stateWatcher.setDaemon(true);
        stateWatcher.start();
        Util.busyWaitAndCheck(this.deadline, this.connectedSupplier);
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.flagStore.shutdown();
        this.onConnectionEvent.accept(new ConnectionEvent(false));
    }

    @Override
    public ProviderEvaluation<Boolean> booleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.resolve(Boolean.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<String> stringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.resolve(String.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Double> doubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.resolve(Double.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Integer> integerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.resolve(Integer.class, key, ctx);
    }

    @Override
    public ProviderEvaluation<Value> objectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Object> evaluation = this.resolve(Object.class, key, ctx);
        return ProviderEvaluation.builder().value((Object)Value.objectToValue((Object)evaluation.getValue())).variant(evaluation.getVariant()).reason(evaluation.getReason()).errorCode(evaluation.getErrorCode()).errorMessage(evaluation.getErrorMessage()).flagMetadata(evaluation.getFlagMetadata()).build();
    }

    static Connector getConnector(FlagdOptions options) {
        if (options.getCustomConnector() != null) {
            return options.getCustomConnector();
        }
        return options.getOfflineFlagSourcePath() != null && !options.getOfflineFlagSourcePath().isEmpty() ? new FileConnector(options.getOfflineFlagSourcePath()) : new GrpcStreamConnector(options);
    }

    private <T> ProviderEvaluation<T> resolve(Class<T> type, String key, EvaluationContext ctx) {
        String reason;
        String resolvedVariant;
        FeatureFlag flag = this.flagStore.getFlag(key);
        if (flag == null) {
            return ProviderEvaluation.builder().errorMessage("flag: " + key + " not found").errorCode(ErrorCode.FLAG_NOT_FOUND).build();
        }
        if ("DISABLED".equals(flag.getState())) {
            return ProviderEvaluation.builder().errorMessage("flag: " + key + " is disabled").errorCode(ErrorCode.FLAG_NOT_FOUND).build();
        }
        if ("{}".equals(flag.getTargeting())) {
            resolvedVariant = flag.getDefaultVariant();
            reason = Reason.STATIC.toString();
        } else {
            try {
                Object jsonResolved = this.operator.apply(key, flag.getTargeting(), ctx);
                if (jsonResolved == null) {
                    resolvedVariant = flag.getDefaultVariant();
                    reason = Reason.DEFAULT.toString();
                } else {
                    resolvedVariant = jsonResolved.toString();
                    reason = Reason.TARGETING_MATCH.toString();
                }
            }
            catch (TargetingRuleException e) {
                String message = String.format("error evaluating targeting rule for flag %s", key);
                log.debug(message, (Throwable)e);
                throw new ParseError(message);
            }
        }
        Object value = flag.getVariants().get(resolvedVariant);
        if (value == null) {
            String message = String.format("variant %s not found in flag with key %s", resolvedVariant, key);
            log.debug(message);
            throw new TypeMismatchError(message);
        }
        if (value instanceof Integer && type == Double.class) {
            value = ((Integer)value).doubleValue();
        } else if (value instanceof Double && type == Integer.class) {
            value = ((Double)value).intValue();
        }
        if (!type.isAssignableFrom(value.getClass())) {
            String message = "returning default variant for flagKey: %s, type not valid";
            log.debug(String.format(message, key));
            throw new TypeMismatchError(message);
        }
        ProviderEvaluation.ProviderEvaluationBuilder evaluationBuilder = ProviderEvaluation.builder().value(value).variant(resolvedVariant).reason(reason);
        return this.metadata == null ? evaluationBuilder.build() : evaluationBuilder.flagMetadata(this.metadata).build();
    }
}

