/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.flipt;

import dev.openfeature.contrib.providers.flipt.ContextTransformer;
import dev.openfeature.contrib.providers.flipt.FliptProviderConfig;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.GeneralError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.flipt.api.FliptClient;
import io.flipt.api.evaluation.models.BooleanEvaluationResponse;
import io.flipt.api.evaluation.models.EvaluationRequest;
import io.flipt.api.evaluation.models.VariantEvaluationResponse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FliptProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FliptProvider.class);
    private static final String NAME = "Flipt";
    public static final String PROVIDER_NOT_YET_INITIALIZED = "provider not yet initialized";
    public static final String UNKNOWN_ERROR = "unknown error";
    private FliptProviderConfig fliptProviderConfig;
    private FliptClient fliptClient;
    private final AtomicBoolean isInitialized = new AtomicBoolean(false);

    public FliptProvider(FliptProviderConfig fliptProviderConfig) {
        this.fliptProviderConfig = fliptProviderConfig;
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        boolean initialized = this.isInitialized.getAndSet(true);
        if (initialized) {
            throw new GeneralError("already initialized");
        }
        super.initialize(evaluationContext);
        this.fliptClient = this.fliptProviderConfig.getFliptClientBuilder().build();
        log.info("finished initializing provider");
    }

    public Metadata getMetadata() {
        return () -> NAME;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        Map<String, String> contextMap = ContextTransformer.transform(ctx);
        EvaluationRequest request = EvaluationRequest.builder().namespaceKey(this.fliptProviderConfig.getNamespace()).flagKey(key).entityId(ctx.getTargetingKey()).context(contextMap).build();
        BooleanEvaluationResponse response = null;
        try {
            response = this.fliptClient.evaluation().evaluateBoolean(request);
        }
        catch (Exception e) {
            log.error("Error evaluating boolean", (Throwable)e);
            throw new GeneralError(e.getMessage());
        }
        return ProviderEvaluation.builder().value((Object)response.isEnabled()).reason(response.getReason().toString()).build();
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.evaluateVariant(String.class, key, new Value(defaultValue), ctx);
        return ProviderEvaluation.builder().value((Object)((Value)valueProviderEvaluation.getValue()).asString()).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.evaluateVariant(Integer.class, key, new Value(defaultValue), ctx);
        Integer value = FliptProvider.getIntegerValue(valueProviderEvaluation, defaultValue);
        return ProviderEvaluation.builder().value((Object)value).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    private static Integer getIntegerValue(ProviderEvaluation<Value> valueProviderEvaluation, Integer defaultValue) {
        String valueStr = ((Value)valueProviderEvaluation.getValue()).asObject().toString();
        try {
            return Integer.parseInt(valueStr);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.evaluateVariant(Double.class, key, new Value(defaultValue), ctx);
        Double value = FliptProvider.getDoubleValue(valueProviderEvaluation, defaultValue);
        return ProviderEvaluation.builder().value((Object)value).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    private static Double getDoubleValue(ProviderEvaluation<Value> valueProviderEvaluation, Double defaultValue) {
        String valueStr = ((Value)valueProviderEvaluation.getValue()).asObject().toString();
        try {
            return Double.parseDouble(valueStr);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.evaluateVariant(Value.class, key, defaultValue, ctx);
    }

    private <T> ProviderEvaluation<Value> evaluateVariant(Class<T> clazz, String key, Value defaultValue, EvaluationContext ctx) {
        VariantEvaluationResponse response;
        Map<String, String> contextMap = ContextTransformer.transform(ctx);
        EvaluationRequest request = EvaluationRequest.builder().namespaceKey(this.fliptProviderConfig.getNamespace()).flagKey(key).entityId(ctx.getTargetingKey()).context(contextMap).build();
        try {
            response = this.fliptClient.evaluation().evaluateVariant(request);
        }
        catch (Exception e) {
            log.error("Error evaluating variant", (Throwable)e);
            throw new GeneralError(e.getMessage());
        }
        if (!response.isMatch()) {
            log.debug("non matching variant for {} : {}", (Object)key, (Object)response.getReason());
            return ProviderEvaluation.builder().value((Object)defaultValue).reason(Reason.DEFAULT.name()).build();
        }
        Value value = new Value(response.getVariantKey());
        ImmutableMetadata.ImmutableMetadataBuilder flagMetadataBuilder = ImmutableMetadata.builder();
        if (response.getVariantAttachment() != null && !response.getVariantAttachment().isEmpty()) {
            flagMetadataBuilder.addString("variant-attachment", response.getVariantAttachment());
            if (clazz.isAssignableFrom(Value.class)) {
                value = new Value(response.getVariantAttachment());
            }
        }
        return ProviderEvaluation.builder().value((Object)value).variant(response.getVariantKey()).reason(Reason.TARGETING_MATCH.name()).flagMetadata(flagMetadataBuilder.build()).build();
    }

    public void shutdown() {
        super.shutdown();
        log.info("shutdown");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected FliptProviderConfig getFliptProviderConfig() {
        return this.fliptProviderConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected void setFliptClient(FliptClient fliptClient) {
        this.fliptClient = fliptClient;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FliptClient getFliptClient() {
        return this.fliptClient;
    }
}

