/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.multiprovider;

import dev.openfeature.contrib.providers.multiprovider.FirstMatchStrategy;
import dev.openfeature.contrib.providers.multiprovider.Strategy;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.GeneralError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiProvider.class);
    private static final String NAME = "multiprovider";
    public static final int INIT_THREADS_COUNT = 8;
    private final Map<String, FeatureProvider> providers;
    private final Strategy strategy;
    private String metadataName;

    public MultiProvider(List<FeatureProvider> providers) {
        this(providers, null);
    }

    public MultiProvider(List<FeatureProvider> providers, Strategy strategy) {
        this.providers = MultiProvider.buildProviders(providers);
        this.strategy = strategy != null ? strategy : new FirstMatchStrategy();
    }

    protected static Map<String, FeatureProvider> buildProviders(List<FeatureProvider> providers) {
        LinkedHashMap<String, FeatureProvider> providersMap = new LinkedHashMap<String, FeatureProvider>(providers.size());
        for (FeatureProvider provider : providers) {
            FeatureProvider prevProvider = providersMap.put(provider.getMetadata().getName(), provider);
            if (prevProvider == null) continue;
            log.warn("duplicated provider name: {}", (Object)provider.getMetadata().getName());
        }
        return Collections.unmodifiableMap(providersMap);
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        JSONObject json = new JSONObject();
        json.put("name", (Object)NAME);
        JSONObject providersMetadata = new JSONObject();
        json.put("originalMetadata", (Object)providersMetadata);
        ExecutorService initPool = Executors.newFixedThreadPool(8);
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>(this.providers.size());
        for (FeatureProvider provider : this.providers.values()) {
            tasks.add(() -> {
                provider.initialize(evaluationContext);
                return true;
            });
            JSONObject providerMetadata = new JSONObject();
            providerMetadata.put("name", (Object)provider.getMetadata().getName());
            providersMetadata.put(provider.getMetadata().getName(), (Object)providerMetadata);
        }
        List results = initPool.invokeAll(tasks);
        for (Future result : results) {
            if (((Boolean)result.get()).booleanValue()) continue;
            throw new GeneralError("init failed");
        }
        this.metadataName = json.toString();
    }

    public Metadata getMetadata() {
        return () -> this.metadataName;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getBooleanEvaluation(key, defaultValue, ctx));
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getStringEvaluation(key, defaultValue, ctx));
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getIntegerEvaluation(key, defaultValue, ctx));
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getDoubleEvaluation(key, defaultValue, ctx));
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        return this.strategy.evaluate(this.providers, key, defaultValue, ctx, p -> p.getObjectEvaluation(key, defaultValue, ctx));
    }

    public void shutdown() {
        log.debug("shutdown begin");
        for (FeatureProvider provider : this.providers.values()) {
            try {
                provider.shutdown();
            }
            catch (Exception e) {
                log.error("error shutdown provider {}", (Object)provider.getMetadata().getName(), (Object)e);
            }
        }
        log.debug("shutdown end");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }
}

