/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.contrib.providers.unleash;

import dev.openfeature.contrib.providers.unleash.ContextTransformer;
import dev.openfeature.contrib.providers.unleash.UnleashProviderConfig;
import dev.openfeature.contrib.providers.unleash.UnleashSubscriberWrapper;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.EventProvider;
import dev.openfeature.sdk.ImmutableMetadata;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.GeneralError;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.getunleash.DefaultUnleash;
import io.getunleash.Unleash;
import io.getunleash.UnleashContext;
import io.getunleash.Variant;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.strategy.Strategy;
import io.getunleash.util.UnleashConfig;
import io.getunleash.variant.Payload;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashProvider
extends EventProvider {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnleashProvider.class);
    private static final String NAME = "Unleash";
    public static final String NOT_IMPLEMENTED = "Not implemented - provider does not support this type. Only boolean is supported.";
    public static final String PROVIDER_NOT_YET_INITIALIZED = "provider not yet initialized";
    public static final String UNKNOWN_ERROR = "unknown error";
    private UnleashProviderConfig unleashProviderConfig;
    private Unleash unleash;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);

    public UnleashProvider(UnleashProviderConfig unleashProviderConfig) {
        this.unleashProviderConfig = unleashProviderConfig;
    }

    public void initialize(EvaluationContext evaluationContext) throws Exception {
        boolean initialized = this.isInitialized.getAndSet(true);
        if (initialized) {
            throw new GeneralError("already initialized");
        }
        super.initialize(evaluationContext);
        UnleashSubscriberWrapper unleashSubscriberWrapper = new UnleashSubscriberWrapper(this.unleashProviderConfig.getUnleashConfigBuilder().build().getSubscriber(), this);
        this.unleashProviderConfig.getUnleashConfigBuilder().subscriber((UnleashSubscriber)unleashSubscriberWrapper);
        UnleashConfig unleashConfig = this.unleashProviderConfig.getUnleashConfigBuilder().build();
        this.unleash = new DefaultUnleash(unleashConfig, new Strategy[0]);
        log.info("finished initializing provider");
    }

    public Metadata getMetadata() {
        return () -> NAME;
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        UnleashContext context = ctx == null ? UnleashContext.builder().build() : ContextTransformer.transform(ctx);
        boolean featureBooleanValue = this.unleash.isEnabled(key, context, defaultValue.booleanValue());
        return ProviderEvaluation.builder().value((Object)featureBooleanValue).build();
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.getObjectEvaluation(key, new Value(defaultValue), ctx);
        return ProviderEvaluation.builder().value((Object)((Value)valueProviderEvaluation.getValue()).asString()).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.getObjectEvaluation(key, new Value(defaultValue), ctx);
        Integer value = UnleashProvider.getIntegerValue(valueProviderEvaluation, defaultValue);
        return ProviderEvaluation.builder().value((Object)value).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    private static Integer getIntegerValue(ProviderEvaluation<Value> valueProviderEvaluation, Integer defaultValue) {
        String valueStr = ((Value)valueProviderEvaluation.getValue()).asObject().toString();
        try {
            return Integer.parseInt(valueStr);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Value> valueProviderEvaluation = this.getObjectEvaluation(key, new Value(defaultValue), ctx);
        Double value = UnleashProvider.getDoubleValue(valueProviderEvaluation, defaultValue);
        return ProviderEvaluation.builder().value((Object)value).variant(valueProviderEvaluation.getVariant()).errorCode(valueProviderEvaluation.getErrorCode()).reason(valueProviderEvaluation.getReason()).flagMetadata(valueProviderEvaluation.getFlagMetadata()).build();
    }

    private static Double getDoubleValue(ProviderEvaluation<Value> valueProviderEvaluation, Double defaultValue) {
        String valueStr = ((Value)valueProviderEvaluation.getValue()).asObject().toString();
        try {
            return Double.parseDouble(valueStr);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        Value value;
        String variantName;
        UnleashContext context = ctx == null ? UnleashContext.builder().build() : ContextTransformer.transform(ctx);
        Variant evaluatedVariant = this.unleash.getVariant(key, context);
        if (Variant.DISABLED_VARIANT.equals((Object)evaluatedVariant)) {
            variantName = null;
            value = defaultValue;
        } else {
            variantName = evaluatedVariant.getName();
            value = evaluatedVariant.getPayload().map(p -> new Value(p.getValue())).orElse(null);
        }
        ImmutableMetadata.ImmutableMetadataBuilder flagMetadataBuilder = ImmutableMetadata.builder().addString("variant-stickiness", evaluatedVariant.getStickiness());
        flagMetadataBuilder.addBoolean("enabled", Boolean.valueOf(evaluatedVariant.isEnabled()));
        if (evaluatedVariant.getPayload().isPresent()) {
            flagMetadataBuilder.addString("payload-type", ((Payload)evaluatedVariant.getPayload().get()).getType());
        }
        return ProviderEvaluation.builder().value((Object)value).variant(variantName).flagMetadata(flagMetadataBuilder.build()).build();
    }

    public void shutdown() {
        super.shutdown();
        log.info("shutdown");
        if (this.unleash != null) {
            this.unleash.shutdown();
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getNAME() {
        return NAME;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected UnleashProviderConfig getUnleashProviderConfig() {
        return this.unleashProviderConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected void setUnleash(Unleash unleash) {
        this.unleash = unleash;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Unleash getUnleash() {
        return this.unleash;
    }
}

