/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.MutableStructure;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class MutableContext
implements EvaluationContext {
    private String targetingKey;
    private final MutableStructure structure;

    public MutableContext() {
        this.structure = new MutableStructure();
        this.targetingKey = "";
    }

    public MutableContext(String targetingKey) {
        this();
        this.targetingKey = targetingKey;
    }

    public MutableContext(Map<String, Value> attributes) {
        this.structure = new MutableStructure(attributes);
        this.targetingKey = "";
    }

    public MutableContext(String targetingKey, Map<String, Value> attributes) {
        this(attributes);
        this.targetingKey = targetingKey;
    }

    public MutableContext add(String key, Boolean value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, String value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Integer value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Double value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Instant value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, Structure value) {
        this.structure.add(key, value);
        return this;
    }

    public MutableContext add(String key, List<Value> value) {
        this.structure.add(key, value);
        return this;
    }

    @Override
    public EvaluationContext merge(EvaluationContext overridingContext) {
        if (overridingContext == null) {
            return new MutableContext(this.asMap());
        }
        HashMap<String, Value> merged = new HashMap<String, Value>();
        merged.putAll(this.asMap());
        merged.putAll(overridingContext.asMap());
        MutableContext ec = new MutableContext(merged);
        if (this.getTargetingKey() != null && !this.getTargetingKey().trim().equals("")) {
            ec.setTargetingKey(this.getTargetingKey());
        }
        if (overridingContext.getTargetingKey() != null && !overridingContext.getTargetingKey().trim().equals("")) {
            ec.setTargetingKey(overridingContext.getTargetingKey());
        }
        return ec;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MutableContext(targetingKey=" + this.getTargetingKey() + ", structure=" + this.structure + ")";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setTargetingKey(String targetingKey) {
        this.targetingKey = targetingKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetingKey() {
        return this.targetingKey;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<String> keySet() {
        return this.structure.keySet();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Value getValue(String key) {
        return this.structure.getValue(key);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Value> asMap() {
        return this.structure.asMap();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> asObjectMap() {
        return this.structure.asObjectMap();
    }

    private static class HideDelegateAddMethods {
        private HideDelegateAddMethods() {
        }

        public MutableStructure add(String ignoredKey, Boolean ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Double ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, String ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Value ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Integer ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, List<Value> ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, MutableStructure ignoredValue) {
            return null;
        }

        public MutableStructure add(String ignoredKey, Instant ignoredValue) {
            return null;
        }
    }
}

