/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.AbstractStructure;
import dev.openfeature.sdk.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public final class ImmutableStructure
extends AbstractStructure {
    public ImmutableStructure() {
    }

    public ImmutableStructure(Map<String, Value> attributes) {
        super(ImmutableStructure.copyAttributes(attributes, null));
    }

    ImmutableStructure(String targetingKey, Map<String, Value> attributes) {
        super(ImmutableStructure.copyAttributes(attributes, targetingKey));
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.attributes.keySet());
    }

    @Override
    public Value getValue(String key) {
        Value value = (Value)this.attributes.get(key);
        return value != null ? value.clone() : null;
    }

    @Override
    public Map<String, Value> asMap() {
        return ImmutableStructure.copyAttributes(this.attributes);
    }

    private static Map<String, Value> copyAttributes(Map<String, Value> in) {
        return ImmutableStructure.copyAttributes(in, null);
    }

    private static Map<String, Value> copyAttributes(Map<String, Value> in, String targetingKey) {
        HashMap<String, Value> copy = new HashMap<String, Value>();
        if (in != null) {
            for (Map.Entry<String, Value> entry : in.entrySet()) {
                copy.put(entry.getKey(), Optional.ofNullable(entry.getValue()).map(val -> val.clone()).orElse(null));
            }
        }
        if (targetingKey != null) {
            copy.put("targetingKey", new Value(targetingKey));
        }
        return copy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ImmutableStructure()";
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableStructure)) {
            return false;
        }
        ImmutableStructure other = (ImmutableStructure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImmutableStructure;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

