/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk;

import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FlagEvaluationDetails;
import dev.openfeature.sdk.FlagValueType;
import dev.openfeature.sdk.Hook;
import dev.openfeature.sdk.HookContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HookSupport {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HookSupport.class);

    public EvaluationContext beforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Hook> hooks, Map<String, Object> hints) {
        return this.callBeforeHooks(flagValueType, hookCtx, hooks, hints);
    }

    public void afterHooks(FlagValueType flagValueType, HookContext hookContext, FlagEvaluationDetails details, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooksUnchecked(flagValueType, hooks, hook -> hook.after(hookContext, details, hints));
    }

    public void afterAllHooks(FlagValueType flagValueType, HookContext hookCtx, FlagEvaluationDetails details, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hooks, "finally", hook -> hook.finallyAfter(hookCtx, details, hints));
    }

    public void errorHooks(FlagValueType flagValueType, HookContext hookCtx, Exception e, List<Hook> hooks, Map<String, Object> hints) {
        this.executeHooks(flagValueType, hooks, "error", hook -> hook.error(hookCtx, e, hints));
    }

    private <T> void executeHooks(FlagValueType flagValueType, List<Hook> hooks, String hookMethod, Consumer<Hook<T>> hookCode) {
        if (hooks != null) {
            for (Hook hook : hooks) {
                if (!hook.supportsFlagValueType(flagValueType)) continue;
                this.executeChecked(hook, hookCode, hookMethod);
            }
        }
    }

    private <T> void executeChecked(Hook<T> hook, Consumer<Hook<T>> hookCode, String hookMethod) {
        try {
            hookCode.accept(hook);
        }
        catch (Exception exception) {
            log.error("Unhandled exception when running {} hook {} (only 'after' hooks should throw)", new Object[]{hookMethod, hook.getClass(), exception});
        }
    }

    private <T> void executeHooksUnchecked(FlagValueType flagValueType, List<Hook> hooks, Consumer<Hook<T>> hookCode) {
        if (hooks != null) {
            for (Hook hook : hooks) {
                if (!hook.supportsFlagValueType(flagValueType)) continue;
                hookCode.accept(hook);
            }
        }
    }

    private EvaluationContext callBeforeHooks(FlagValueType flagValueType, HookContext hookCtx, List<Hook> hooks, Map<String, Object> hints) {
        ArrayList<Hook> reversedHooks = new ArrayList<Hook>(hooks);
        Collections.reverse(reversedHooks);
        EvaluationContext context = hookCtx.getCtx();
        for (Hook hook : reversedHooks) {
            Optional optional;
            if (!hook.supportsFlagValueType(flagValueType) || !(optional = Optional.ofNullable(hook.before(hookCtx, hints)).orElse(Optional.empty())).isPresent()) continue;
            context = context.merge((EvaluationContext)optional.get());
        }
        return context;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HookSupport() {
    }
}

