/*
 * Decompiled with CFR 0.152.
 */
package dev.openfeature.sdk.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class ConfigurableThreadFactory
implements ThreadFactory {
    private final AtomicInteger counter = new AtomicInteger();
    private final String namePrefix;
    private final boolean daemon;

    public ConfigurableThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public ConfigurableThreadFactory(String namePrefix, boolean daemon) {
        this.namePrefix = namePrefix;
        this.daemon = daemon;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(this.daemon);
        thread.setName(this.namePrefix + "-" + this.counter.incrementAndGet());
        return thread;
    }
}

