/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.auth;

import dev.openfga.sdk.util.StringUtil;
import java.time.Instant;
import java.util.Random;

class AccessToken {
    private static final int TOKEN_EXPIRY_BUFFER_THRESHOLD_IN_SEC = 300;
    private static final int TOKEN_EXPIRY_JITTER_IN_SEC = 300;
    private final Random random = new Random();
    private Instant expiresAt;
    private String token;

    AccessToken() {
    }

    public boolean isValid() {
        return !StringUtil.isNullOrWhitespace(this.token) && (this.expiresAt == null || this.expiresAt.isBefore(Instant.now().plusSeconds(300L).plusSeconds(this.random.nextLong() % 300L)));
    }

    public String getToken() {
        return this.token;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

