/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.auth;

import dev.openfga.sdk.api.auth.AccessToken;
import dev.openfga.sdk.api.auth.CredentialsFlowRequest;
import dev.openfga.sdk.api.auth.CredentialsFlowResponse;
import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.ApiResponse;
import dev.openfga.sdk.api.client.HttpRequestAttempt;
import dev.openfga.sdk.api.configuration.ClientCredentials;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.errors.ApiException;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;

public class OAuth2Client {
    private static final String DEFAULT_API_TOKEN_ISSUER_PATH = "/oauth/token";
    private final ApiClient apiClient;
    private final String apiTokenIssuer;
    private final AccessToken token = new AccessToken();
    private final CredentialsFlowRequest authRequest;

    public OAuth2Client(Configuration configuration, ApiClient apiClient) throws FgaInvalidParameterException {
        ClientCredentials clientCredentials = configuration.getCredentials().getClientCredentials();
        this.apiClient = apiClient;
        this.apiTokenIssuer = OAuth2Client.buildApiTokenIssuer(clientCredentials.getApiTokenIssuer());
        this.authRequest = new CredentialsFlowRequest();
        this.authRequest.setClientId(clientCredentials.getClientId());
        this.authRequest.setClientSecret(clientCredentials.getClientSecret());
        this.authRequest.setAudience(clientCredentials.getApiAudience());
        this.authRequest.setScope(clientCredentials.getScopes());
        this.authRequest.setGrantType("client_credentials");
    }

    public CompletableFuture<String> getAccessToken() throws FgaInvalidParameterException, ApiException {
        if (!this.token.isValid()) {
            return this.exchangeToken().thenCompose(response -> {
                this.token.setToken(response.getAccessToken());
                this.token.setExpiresAt(Instant.now().plusSeconds(response.getExpiresInSeconds()));
                return CompletableFuture.completedFuture(this.token.getToken());
            });
        }
        return CompletableFuture.completedFuture(this.token.getToken());
    }

    private CompletableFuture<CredentialsFlowResponse> exchangeToken() throws ApiException, FgaInvalidParameterException {
        try {
            byte[] body = this.apiClient.getObjectMapper().writeValueAsBytes((Object)this.authRequest);
            Configuration config = new Configuration().apiUrl(this.apiTokenIssuer);
            HttpRequest.Builder requestBuilder = ApiClient.requestBuilder("POST", "", body, config);
            HttpRequest request = requestBuilder.build();
            return new HttpRequestAttempt<CredentialsFlowResponse>(request, "exchangeToken", CredentialsFlowResponse.class, this.apiClient, config).attemptHttpRequest().thenApply(ApiResponse::getData);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private static String buildApiTokenIssuer(String issuer) throws FgaInvalidParameterException {
        URI uri;
        try {
            uri = URI.create(issuer);
        }
        catch (IllegalArgumentException cause) {
            throw new FgaInvalidParameterException("apiTokenIssuer", "ClientCredentials", cause);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            uri = URI.create("https://" + issuer);
        } else if (!"https".equals(scheme) && !"http".equals(scheme)) {
            throw new FgaInvalidParameterException("scheme", "apiTokenIssuer");
        }
        if (uri.getPath().isEmpty() || uri.getPath().equals("/")) {
            uri = URI.create(uri.getScheme() + "://" + uri.getAuthority() + DEFAULT_API_TOKEN_ISSUER_PATH);
        }
        return uri.toString();
    }
}

