/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.RelationshipCondition;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"user", "relation", "object", "condition"})
public class TupleKey {
    public static final String JSON_PROPERTY_USER = "user";
    private String user;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;
    public static final String JSON_PROPERTY_OBJECT = "object";
    private String _object;
    public static final String JSON_PROPERTY_CONDITION = "condition";
    private RelationshipCondition condition;

    public TupleKey user(String user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(String user) {
        this.user = user;
    }

    public TupleKey relation(String relation) {
        this.relation = relation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public TupleKey _object(String _object) {
        this._object = _object;
        return this;
    }

    @Nonnull
    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getObject() {
        return this._object;
    }

    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObject(String _object) {
        this._object = _object;
    }

    public TupleKey condition(RelationshipCondition condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipCondition getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCondition(RelationshipCondition condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleKey tupleKey = (TupleKey)o;
        return Objects.equals(this.user, tupleKey.user) && Objects.equals(this.relation, tupleKey.relation) && Objects.equals(this._object, tupleKey._object) && Objects.equals(this.condition, tupleKey.condition);
    }

    public int hashCode() {
        return Objects.hash(this.user, this.relation, this._object, this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TupleKey {\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getUser() != null) {
            joiner.add(String.format("%suser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUser()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getObject() != null) {
            joiner.add(String.format("%sobject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getObject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCondition() != null) {
            joiner.add(this.getCondition().toUrlQueryString((String)prefix + JSON_PROPERTY_CONDITION + suffix));
        }
        return joiner.toString();
    }
}

