/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.util;

import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.util.StringUtil;
import java.util.Optional;

public class Pair {
    private String name = "";
    private String value = "";

    public Pair(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public static Optional<Pair> of(String name, Object value) {
        if (StringUtil.isNullOrWhitespace(name) || value == null) {
            return Optional.empty();
        }
        return Optional.of(new Pair(name, value.toString()));
    }

    public String asQueryStringPair() {
        return ApiClient.urlEncode(this.name) + "=" + ApiClient.urlEncode(this.value);
    }

    private void setName(String name) {
        if (!this.isValidString(name)) {
            return;
        }
        this.name = name;
    }

    private void setValue(String value) {
        if (!this.isValidString(value)) {
            return;
        }
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    private boolean isValidString(String arg) {
        return arg != null;
    }
}

