/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client.model;

import dev.openfga.sdk.api.client.model.ClientBatchCheckResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ClientListRelationsResponse {
    private final List<String> relations;

    public ClientListRelationsResponse(List<String> relations) {
        this.relations = relations;
    }

    public List<String> getRelations() {
        return this.relations;
    }

    public static ClientListRelationsResponse fromBatchCheckResponses(List<ClientBatchCheckResponse> responses) throws Throwable {
        Optional<ClientBatchCheckResponse> failedResponse = responses.stream().filter(response -> response.getThrowable() != null).findFirst();
        if (failedResponse.isPresent()) {
            throw failedResponse.get().getThrowable();
        }
        List<String> relations = responses.stream().filter(ClientBatchCheckResponse::getAllowed).map(ClientBatchCheckResponse::getRelation).collect(Collectors.toList());
        return new ClientListRelationsResponse(relations);
    }
}

