/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.configuration;

import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.util.Validation;
import java.time.Duration;

public class ClientConfiguration
extends Configuration {
    private String storeId;
    private String authorizationModelId;

    public void assertValidStoreId() throws FgaInvalidParameterException {
        Validation.assertParamExists(this.storeId, "storeId", "ClientConfiguration");
    }

    public void assertValidAuthorizationModelId() throws FgaInvalidParameterException {
        Validation.assertParamExists(this.authorizationModelId, "authorizationModelId", "ClientConfiguration");
    }

    public ClientConfiguration storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getStoreIdChecked() throws FgaInvalidParameterException {
        this.assertValidStoreId();
        return this.storeId;
    }

    public ClientConfiguration authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public String getAuthorizationModelIdChecked() throws FgaInvalidParameterException {
        this.assertValidAuthorizationModelId();
        return this.authorizationModelId;
    }

    @Override
    public ClientConfiguration apiUrl(String apiUrl) {
        super.apiUrl(apiUrl);
        return this;
    }

    @Override
    public ClientConfiguration credentials(Credentials credentials) {
        super.credentials(credentials);
        return this;
    }

    @Override
    public ClientConfiguration userAgent(String userAgent) {
        super.userAgent(userAgent);
        return this;
    }

    @Override
    public ClientConfiguration readTimeout(Duration readTimeout) {
        super.readTimeout(readTimeout);
        return this;
    }

    @Override
    public ClientConfiguration connectTimeout(Duration connectTimeout) {
        super.connectTimeout(connectTimeout);
        return this;
    }

    @Override
    public ClientConfiguration maxRetries(int maxRetries) {
        super.maxRetries(maxRetries);
        return this;
    }

    @Override
    public ClientConfiguration minimumRetryDelay(Duration minimumRetryDelay) {
        super.minimumRetryDelay(minimumRetryDelay);
        return this;
    }
}

