/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.auth;

import static dev.openfga.sdk.util.StringUtil.isNullOrWhitespace;

import java.time.Instant;
import java.util.Random;

class AccessToken {
    private static final int TOKEN_EXPIRY_BUFFER_THRESHOLD_IN_SEC = 300;
    private static final int TOKEN_EXPIRY_JITTER_IN_SEC =
            300; // We add some jitter so that token refreshes are less likely to collide

    private final Random random = new Random();
    private Instant expiresAt;

    private String token;

    public boolean isValid() {
        return !isNullOrWhitespace(token)
                && (expiresAt == null
                        || expiresAt.isAfter(Instant.now()
                                .minusSeconds(TOKEN_EXPIRY_BUFFER_THRESHOLD_IN_SEC)
                                .minusSeconds(random.nextLong() % TOKEN_EXPIRY_JITTER_IN_SEC)));
    }

    public String getToken() {
        return token;
    }

    public void setExpiresAt(Instant expiresAt) {
        this.expiresAt = expiresAt;
    }

    public void setToken(String token) {
        this.token = token;
    }
}
