/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 0.1
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * ListObjectsRequest
 */
@JsonPropertyOrder({
    ListObjectsRequest.JSON_PROPERTY_AUTHORIZATION_MODEL_ID,
    ListObjectsRequest.JSON_PROPERTY_TYPE,
    ListObjectsRequest.JSON_PROPERTY_RELATION,
    ListObjectsRequest.JSON_PROPERTY_USER,
    ListObjectsRequest.JSON_PROPERTY_CONTEXTUAL_TUPLES,
    ListObjectsRequest.JSON_PROPERTY_CONTEXT
})
public class ListObjectsRequest {
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;

    public static final String JSON_PROPERTY_USER = "user";
    private String user;

    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    private ContextualTupleKeys contextualTuples;

    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Object context;

    public ListObjectsRequest() {}

    public ListObjectsRequest authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    /**
     * Get authorizationModelId
     * @return authorizationModelId
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_MODEL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return authorizationModelId;
    }

    @JsonProperty(JSON_PROPERTY_AUTHORIZATION_MODEL_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ListObjectsRequest type(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get type
     * @return type
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ListObjectsRequest relation(String relation) {
        this.relation = relation;
        return this;
    }

    /**
     * Get relation
     * @return relation
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_RELATION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public String getRelation() {
        return relation;
    }

    @JsonProperty(JSON_PROPERTY_RELATION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public ListObjectsRequest user(String user) {
        this.user = user;
        return this;
    }

    /**
     * Get user
     * @return user
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public String getUser() {
        return user;
    }

    @JsonProperty(JSON_PROPERTY_USER)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUser(String user) {
        this.user = user;
    }

    public ListObjectsRequest contextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    /**
     * Get contextualTuples
     * @return contextualTuples
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_CONTEXTUAL_TUPLES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return contextualTuples;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXTUAL_TUPLES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public ListObjectsRequest context(Object context) {
        this.context = context;
        return this;
    }

    /**
     * Additional request context that will be used to evaluate any ABAC conditions encountered in the query evaluation.
     * @return context
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return context;
    }

    @JsonProperty(JSON_PROPERTY_CONTEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Object context) {
        this.context = context;
    }

    /**
     * Return true if this ListObjects_request object is equal to o.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ListObjectsRequest listObjectsRequest = (ListObjectsRequest) o;
        return Objects.equals(this.authorizationModelId, listObjectsRequest.authorizationModelId)
                && Objects.equals(this.type, listObjectsRequest.type)
                && Objects.equals(this.relation, listObjectsRequest.relation)
                && Objects.equals(this.user, listObjectsRequest.user)
                && Objects.equals(this.contextualTuples, listObjectsRequest.contextualTuples)
                && Objects.equals(this.context, listObjectsRequest.context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(authorizationModelId, type, relation, user, contextualTuples, context);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListObjectsRequest {\n");
        sb.append("    authorizationModelId: ")
                .append(toIndentedString(authorizationModelId))
                .append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    relation: ").append(toIndentedString(relation)).append("\n");
        sb.append("    user: ").append(toIndentedString(user)).append("\n");
        sb.append("    contextualTuples: ")
                .append(toIndentedString(contextualTuples))
                .append("\n");
        sb.append("    context: ").append(toIndentedString(context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    /**
     * Convert the instance into URL query string.
     *
     * @return URL query string
     */
    public String toUrlQueryString() {
        return toUrlQueryString(null);
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix prefix of the query string
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            // style=form, explode=true, e.g. /pet?name=cat&type=manx
            prefix = "";
        } else {
            // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }

        StringJoiner joiner = new StringJoiner("&");

        // add `authorization_model_id` to the URL query string
        if (getAuthorizationModelId() != null) {
            joiner.add(String.format(
                    "%sauthorization_model_id%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getAuthorizationModelId()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `type` to the URL query string
        if (getType() != null) {
            joiner.add(String.format(
                    "%stype%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getType()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `relation` to the URL query string
        if (getRelation() != null) {
            joiner.add(String.format(
                    "%srelation%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getRelation()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `user` to the URL query string
        if (getUser() != null) {
            joiner.add(String.format(
                    "%suser%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getUser()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `contextual_tuples` to the URL query string
        if (getContextualTuples() != null) {
            joiner.add(getContextualTuples().toUrlQueryString(prefix + "contextual_tuples" + suffix));
        }

        // add `context` to the URL query string
        if (getContext() != null) {
            joiner.add(String.format(
                    "%scontext%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getContext()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        return joiner.toString();
    }
}
