/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.configuration;

import dev.openfga.sdk.api.configuration.BaseConfiguration;
import dev.openfga.sdk.api.configuration.ConfigurationOverride;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.util.StringUtil;
import dev.openfga.sdk.util.Validation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class Configuration
implements BaseConfiguration {
    public static final String VERSION = "0.4.1";
    private static final String DEFAULT_API_URL = "http://localhost:8080";
    private static final String DEFAULT_USER_AGENT = "openfga-sdk java/0.4.1";
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
    private String apiUrl = "http://localhost:8080";
    private Credentials credentials;
    private String userAgent = "openfga-sdk java/0.4.1";
    private Duration readTimeout = DEFAULT_READ_TIMEOUT;
    private Duration connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private int maxRetries;
    private Duration minimumRetryDelay;
    private Map<String, String> defaultHeaders;

    public void assertValid() throws FgaInvalidParameterException {
        if (!StringUtil.isNullOrWhitespace(this.apiUrl)) {
            URI uri;
            try {
                uri = URI.create(this.apiUrl);
                URL uRL = uri.toURL();
            }
            catch (IllegalArgumentException | MalformedURLException cause) {
                throw new FgaInvalidParameterException("apiUrl", "Configuration", cause);
            }
            Validation.assertParamExists(uri.getScheme(), "scheme", "Configuration");
            Validation.assertParamExists(uri.getHost(), "hostname", "Configuration");
        }
        if (this.credentials != null) {
            this.credentials.assertValid();
        }
    }

    public Configuration override(ConfigurationOverride configurationOverride) {
        Map<String, String> additionalHeaders;
        Configuration result = new Configuration();
        String overrideApiUrl = configurationOverride.getApiUrl();
        result.apiUrl(overrideApiUrl != null ? overrideApiUrl : this.apiUrl);
        Credentials overrideCredentials = configurationOverride.getCredentials();
        result.credentials(overrideCredentials != null ? overrideCredentials : this.credentials);
        String overrideUserAgent = configurationOverride.getUserAgent();
        result.userAgent(overrideUserAgent != null ? overrideUserAgent : this.userAgent);
        Duration overrideReadTimeout = configurationOverride.getReadTimeout();
        result.readTimeout(overrideReadTimeout != null ? overrideReadTimeout : this.readTimeout);
        Duration overrideConnectTimeout = configurationOverride.getConnectTimeout();
        result.connectTimeout(overrideConnectTimeout != null ? overrideConnectTimeout : this.connectTimeout);
        Integer overrideMaxRetries = configurationOverride.getMaxRetries();
        result.maxRetries(overrideMaxRetries != null ? overrideMaxRetries : this.maxRetries);
        Duration overrideMinimumRetryDelay = configurationOverride.getMinimumRetryDelay();
        result.minimumRetryDelay(overrideMinimumRetryDelay != null ? overrideMinimumRetryDelay : this.minimumRetryDelay);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.defaultHeaders != null) {
            headers.putAll(this.defaultHeaders);
        }
        if ((additionalHeaders = configurationOverride.getAdditionalHeaders()) != null) {
            additionalHeaders.forEach((header, value) -> {
                if (value == null) {
                    headers.remove(header);
                } else {
                    headers.put((String)header, (String)value);
                }
            });
        }
        result.defaultHeaders(headers);
        return result;
    }

    public Configuration apiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Override
    public String getApiUrl() {
        if (StringUtil.isNullOrWhitespace(this.apiUrl)) {
            return DEFAULT_API_URL;
        }
        return this.apiUrl;
    }

    public Configuration userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public Configuration credentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public Credentials getCredentials() {
        if (this.credentials == null) {
            return new Credentials();
        }
        return this.credentials;
    }

    public Configuration readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Configuration connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Configuration maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Configuration minimumRetryDelay(Duration minimumRetryDelay) {
        this.minimumRetryDelay = minimumRetryDelay;
        return this;
    }

    @Override
    public Duration getMinimumRetryDelay() {
        return this.minimumRetryDelay;
    }

    public Configuration defaultHeaders(Map<String, String> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public Map<String, String> getDefaultHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = Map.of();
        }
        return this.defaultHeaders;
    }
}

