/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.configuration;

import dev.openfga.sdk.api.configuration.AdditionalHeadersSupplier;
import dev.openfga.sdk.api.configuration.BaseConfiguration;
import dev.openfga.sdk.api.configuration.Credentials;
import java.time.Duration;
import java.util.Map;

public class ConfigurationOverride
implements BaseConfiguration {
    private String apiUrl = null;
    private Credentials credentials = null;
    private String userAgent = null;
    private Duration readTimeout = null;
    private Duration connectTimeout = null;
    private Integer maxRetries;
    private Duration minimumRetryDelay;
    private Map<String, String> additionalHeaders = null;

    public ConfigurationOverride apiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    public ConfigurationOverride credentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public ConfigurationOverride userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    public ConfigurationOverride readTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public ConfigurationOverride connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public ConfigurationOverride maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public ConfigurationOverride minimumRetryDelay(Duration minimumRetryDelay) {
        this.minimumRetryDelay = minimumRetryDelay;
        return this;
    }

    @Override
    public Duration getMinimumRetryDelay() {
        return this.minimumRetryDelay;
    }

    public ConfigurationOverride additionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public ConfigurationOverride addHeaders(AdditionalHeadersSupplier supplier) {
        if (supplier == null || supplier.getAdditionalHeaders() == null) {
            return this;
        }
        Map<String, String> additionalHeaders = supplier.getAdditionalHeaders();
        if (this.additionalHeaders != null) {
            this.additionalHeaders.putAll(additionalHeaders);
        } else {
            this.additionalHeaders = additionalHeaders;
        }
        return this;
    }

    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }
}

