/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "relation", "wildcard", "condition"})
public class RelationReference {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;
    public static final String JSON_PROPERTY_WILDCARD = "wildcard";
    private Object wildcard;
    public static final String JSON_PROPERTY_CONDITION = "condition";
    private String condition;

    public RelationReference type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public RelationReference relation(String relation) {
        this.relation = relation;
        return this;
    }

    @Nullable
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public RelationReference wildcard(Object wildcard) {
        this.wildcard = wildcard;
        return this;
    }

    @Nullable
    @JsonProperty(value="wildcard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getWildcard() {
        return this.wildcard;
    }

    @JsonProperty(value="wildcard")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWildcard(Object wildcard) {
        this.wildcard = wildcard;
    }

    public RelationReference condition(String condition) {
        this.condition = condition;
        return this;
    }

    @Nullable
    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCondition() {
        return this.condition;
    }

    @JsonProperty(value="condition")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationReference relationReference = (RelationReference)o;
        return Objects.equals(this.type, relationReference.type) && Objects.equals(this.relation, relationReference.relation) && Objects.equals(this.wildcard, relationReference.wildcard) && Objects.equals(this.condition, relationReference.condition);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.relation, this.wildcard, this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelationReference {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    wildcard: ").append(this.toIndentedString(this.wildcard)).append("\n");
        sb.append("    condition: ").append(this.toIndentedString(this.condition)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getWildcard() != null) {
            joiner.add(String.format("%swildcard%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getWildcard()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCondition() != null) {
            joiner.add(String.format("%scondition%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCondition()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

