/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.TupleKey;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"key", "timestamp"})
public class Tuple {
    public static final String JSON_PROPERTY_KEY = "key";
    private TupleKey key;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;

    public Tuple key(TupleKey key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TupleKey getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(TupleKey key) {
        this.key = key;
    }

    public Tuple timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tuple tuple = (Tuple)o;
        return Objects.equals(this.key, tuple.key) && Objects.equals(this.timestamp, tuple.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tuple {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getKey() != null) {
            joiner.add(this.getKey().toUrlQueryString((String)prefix + JSON_PROPERTY_KEY + suffix));
        }
        if (this.getTimestamp() != null) {
            joiner.add(String.format("%stimestamp%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTimestamp()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

