/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApiClient {
    private HttpClient.Builder builder;
    private HttpClient client;
    private ObjectMapper mapper;
    private Consumer<HttpRequest.Builder> interceptor;
    private Consumer<HttpResponse<InputStream>> responseInterceptor;
    private Consumer<HttpResponse<String>> asyncResponseInterceptor;

    public ApiClient() {
        this.builder = this.createDefaultHttpClientBuilder();
        this.mapper = this.createDefaultObjectMapper();
        this.client = this.builder.build();
        this.interceptor = null;
        this.responseInterceptor = null;
        this.asyncResponseInterceptor = null;
    }

    public ApiClient(HttpClient.Builder builder, ObjectMapper mapper) {
        this.builder = builder;
        this.mapper = mapper;
        this.client = this.builder.build();
        this.interceptor = null;
        this.responseInterceptor = null;
        this.asyncResponseInterceptor = null;
    }

    private static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return value.toString();
    }

    public static HttpRequest.Builder requestBuilder(String method, String path, Configuration configuration) throws FgaInvalidParameterException {
        return ApiClient.requestBuilder(method, path, HttpRequest.BodyPublishers.noBody(), configuration);
    }

    public static HttpRequest.Builder requestBuilder(String method, String path, byte[] body, Configuration configuration) throws FgaInvalidParameterException {
        HttpRequest.Builder builder = ApiClient.requestBuilder(method, path, HttpRequest.BodyPublishers.ofByteArray(body), configuration);
        builder.header("content-type", "application/json");
        return builder;
    }

    public static HttpRequest.Builder formRequestBuilder(String method, String path, String body, Configuration configuration) throws FgaInvalidParameterException {
        HttpRequest.Builder builder = ApiClient.requestBuilder(method, path, HttpRequest.BodyPublishers.ofString(body), configuration);
        builder.header("content-type", "application/x-www-form-urlencoded");
        return builder;
    }

    private static HttpRequest.Builder requestBuilder(String method, String path, HttpRequest.BodyPublisher bodyPublisher, Configuration configuration) throws FgaInvalidParameterException {
        configuration.assertValid();
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        builder.uri(URI.create(configuration.getApiUrl() + path));
        builder.header("accept", "application/json");
        builder.method(method, bodyPublisher);
        Duration readTimeout = configuration.getReadTimeout();
        if (readTimeout != null) {
            builder.timeout(readTimeout);
        }
        return builder;
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8).replaceAll("\\+", "%20");
    }

    protected ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE, false);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.registerModule((Module)new JsonNullableModule());
        return mapper;
    }

    protected String getDefaultBaseUri() {
        return "http://localhost";
    }

    protected HttpClient.Builder createDefaultHttpClientBuilder() {
        return HttpClient.newBuilder();
    }

    public ApiClient setHttpClientBuilder(HttpClient.Builder builder) {
        this.builder = builder;
        this.client = this.builder.build();
        return this;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public HttpClient.Builder getHttpClientBuilder() {
        return this.builder;
    }

    public ApiClient setObjectMapper(ObjectMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public ApiClient setRequestInterceptor(Consumer<HttpRequest.Builder> interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public void addRequestInterceptor(Consumer<HttpRequest.Builder> interceptor) {
        this.interceptor = this.interceptor != null ? this.interceptor.andThen(interceptor) : interceptor;
    }

    public Consumer<HttpRequest.Builder> getRequestInterceptor() {
        return this.interceptor;
    }

    public ApiClient setResponseInterceptor(Consumer<HttpResponse<InputStream>> interceptor) {
        this.responseInterceptor = interceptor;
        return this;
    }

    public Consumer<HttpResponse<InputStream>> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public ApiClient setAsyncResponseInterceptor(Consumer<HttpResponse<String>> interceptor) {
        this.asyncResponseInterceptor = interceptor;
        return this;
    }

    public Consumer<HttpResponse<String>> getAsyncResponseInterceptor() {
        return this.asyncResponseInterceptor;
    }
}

