/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client;

import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.ApiResponse;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.errors.ApiException;
import dev.openfga.sdk.errors.FgaError;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.errors.HttpStatusCode;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Attributes;
import dev.openfga.sdk.telemetry.Telemetry;
import dev.openfga.sdk.util.StringUtil;
import dev.openfga.sdk.util.Validation;
import java.io.IOException;
import java.io.PrintStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;

public class HttpRequestAttempt<T> {
    private final ApiClient apiClient;
    private final Configuration configuration;
    private final Class<T> clazz;
    private final String name;
    private final HttpRequest request;
    private final Telemetry telemetry;
    private Long requestStarted;
    private Map<Attribute, String> telemetryAttributes;
    private final boolean enableDebugLogging = "enable".equals(System.getProperty("HttpRequestAttempt.debug-logging"));

    public HttpRequestAttempt(HttpRequest request, String name, Class<T> clazz, ApiClient apiClient, Configuration configuration) throws FgaInvalidParameterException {
        Validation.assertParamExists(configuration.getMaxRetries(), "maxRetries", "Configuration");
        this.apiClient = apiClient;
        this.configuration = configuration;
        this.name = name;
        this.request = request;
        this.clazz = clazz;
        this.telemetry = new Telemetry(configuration);
        this.telemetryAttributes = new HashMap<Attribute, String>();
    }

    public Map<Attribute, String> getTelemetryAttributes() {
        return this.telemetryAttributes;
    }

    public HttpRequestAttempt<T> setTelemetryAttributes(Map<Attribute, String> attributes) {
        this.telemetryAttributes = attributes;
        return this;
    }

    public HttpRequestAttempt<T> addTelemetryAttribute(Attribute attribute, String value) {
        this.telemetryAttributes.put(attribute, value);
        return this;
    }

    public HttpRequestAttempt<T> addTelemetryAttributes(Map<Attribute, String> attributes) {
        this.telemetryAttributes.putAll(attributes);
        return this;
    }

    public CompletableFuture<ApiResponse<T>> attemptHttpRequest() throws ApiException {
        this.requestStarted = System.currentTimeMillis();
        if (this.enableDebugLogging) {
            this.request.bodyPublisher().ifPresent(requestBodyPublisher -> requestBodyPublisher.subscribe(new BodyLogger(System.err, "request")));
        }
        this.addTelemetryAttribute(Attributes.HTTP_HOST, this.request.uri().getHost());
        this.addTelemetryAttribute(Attributes.URL_SCHEME, this.request.uri().getScheme());
        this.addTelemetryAttribute(Attributes.URL_FULL, this.request.uri().toString());
        this.addTelemetryAttribute(Attributes.HTTP_REQUEST_METHOD, this.request.method());
        this.addTelemetryAttribute(Attributes.USER_AGENT, this.configuration.getUserAgent());
        return this.attemptHttpRequest(this.createClient(), 0, null);
    }

    private HttpClient createClient() {
        return this.apiClient.getHttpClient();
    }

    private CompletableFuture<ApiResponse<T>> attemptHttpRequest(HttpClient httpClient, int retryNumber, Throwable previousError) {
        return httpClient.sendAsync(this.request, HttpResponse.BodyHandlers.ofString()).thenCompose(response -> {
            String queryDuration;
            Optional<FgaError> fgaError = FgaError.getError(this.name, this.request, this.configuration, response, previousError);
            if (fgaError.isPresent()) {
                FgaError error = fgaError.get();
                if (HttpStatusCode.isRetryable(error.getStatusCode()) && retryNumber < this.configuration.getMaxRetries()) {
                    HttpClient delayingClient = this.getDelayedHttpClient();
                    return this.attemptHttpRequest(delayingClient, retryNumber + 1, error);
                }
                return CompletableFuture.failedFuture(error);
            }
            this.addTelemetryAttributes(Attributes.fromHttpResponse(response, this.configuration.getCredentials()));
            if (retryNumber > 0) {
                this.addTelemetryAttribute(Attributes.HTTP_REQUEST_RESEND_COUNT, String.valueOf(retryNumber));
            }
            if (response.headers().firstValue("fga-query-duration-ms").isPresent() && !StringUtil.isNullOrWhitespace(queryDuration = (String)response.headers().firstValue("fga-query-duration-ms").orElse(null))) {
                double queryDurationDouble = Double.parseDouble(queryDuration);
                this.telemetry.metrics().queryDuration(queryDurationDouble, this.getTelemetryAttributes());
            }
            Double requestDuration = System.currentTimeMillis() - this.requestStarted;
            this.telemetry.metrics().requestDuration(requestDuration, this.getTelemetryAttributes());
            return this.deserializeResponse((HttpResponse<String>)response).thenApply(modeledResponse -> new ApiResponse<Object>(response.statusCode(), response.headers().map(), (String)response.body(), modeledResponse));
        });
    }

    private CompletableFuture<T> deserializeResponse(HttpResponse<String> response) {
        if (this.clazz == Void.class && StringUtil.isNullOrWhitespace(response.body())) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            Object deserialized = this.apiClient.getObjectMapper().readValue(response.body(), this.clazz);
            return CompletableFuture.completedFuture(deserialized);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new ApiException(e));
        }
    }

    private HttpClient getDelayedHttpClient() {
        Duration retryDelay = this.configuration.getMinimumRetryDelay();
        return this.apiClient.getHttpClientBuilder().executor(CompletableFuture.delayedExecutor(retryDelay.toNanos(), TimeUnit.NANOSECONDS)).build();
    }

    private static class BodyLogger
    implements Flow.Subscriber<ByteBuffer> {
        private final PrintStream out;
        private final String target;

        BodyLogger(PrintStream out, String target) {
            this.out = out;
            this.target = target;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.out.printf("[%s] subscribed: %s\n", this.getClass().getName(), subscription);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer item) {
            this.out.printf("[%s] %s: %s\n", this.getClass().getName(), this.target, new String(item.array(), StandardCharsets.UTF_8));
        }

        @Override
        public void onError(Throwable throwable) {
            this.out.printf("[%s] error: %s\n", this.getClass().getName(), throwable);
        }

        @Override
        public void onComplete() {
            this.out.flush();
        }
    }
}

