/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client;

import dev.openfga.sdk.api.OpenFgaApi;
import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.ClientAssertion;
import dev.openfga.sdk.api.client.model.ClientBatchCheckResponse;
import dev.openfga.sdk.api.client.model.ClientCheckRequest;
import dev.openfga.sdk.api.client.model.ClientCheckResponse;
import dev.openfga.sdk.api.client.model.ClientCreateStoreResponse;
import dev.openfga.sdk.api.client.model.ClientDeleteStoreResponse;
import dev.openfga.sdk.api.client.model.ClientExpandRequest;
import dev.openfga.sdk.api.client.model.ClientExpandResponse;
import dev.openfga.sdk.api.client.model.ClientGetStoreResponse;
import dev.openfga.sdk.api.client.model.ClientListObjectsRequest;
import dev.openfga.sdk.api.client.model.ClientListObjectsResponse;
import dev.openfga.sdk.api.client.model.ClientListRelationsRequest;
import dev.openfga.sdk.api.client.model.ClientListRelationsResponse;
import dev.openfga.sdk.api.client.model.ClientListStoresResponse;
import dev.openfga.sdk.api.client.model.ClientListUsersRequest;
import dev.openfga.sdk.api.client.model.ClientListUsersResponse;
import dev.openfga.sdk.api.client.model.ClientReadAssertionsResponse;
import dev.openfga.sdk.api.client.model.ClientReadAuthorizationModelResponse;
import dev.openfga.sdk.api.client.model.ClientReadAuthorizationModelsResponse;
import dev.openfga.sdk.api.client.model.ClientReadChangesRequest;
import dev.openfga.sdk.api.client.model.ClientReadChangesResponse;
import dev.openfga.sdk.api.client.model.ClientReadRequest;
import dev.openfga.sdk.api.client.model.ClientReadResponse;
import dev.openfga.sdk.api.client.model.ClientTupleKey;
import dev.openfga.sdk.api.client.model.ClientTupleKeyWithoutCondition;
import dev.openfga.sdk.api.client.model.ClientWriteAssertionsResponse;
import dev.openfga.sdk.api.client.model.ClientWriteAuthorizationModelResponse;
import dev.openfga.sdk.api.client.model.ClientWriteRequest;
import dev.openfga.sdk.api.client.model.ClientWriteResponse;
import dev.openfga.sdk.api.configuration.ClientBatchCheckOptions;
import dev.openfga.sdk.api.configuration.ClientCheckOptions;
import dev.openfga.sdk.api.configuration.ClientConfiguration;
import dev.openfga.sdk.api.configuration.ClientCreateStoreOptions;
import dev.openfga.sdk.api.configuration.ClientDeleteStoreOptions;
import dev.openfga.sdk.api.configuration.ClientDeleteTuplesOptions;
import dev.openfga.sdk.api.configuration.ClientExpandOptions;
import dev.openfga.sdk.api.configuration.ClientGetStoreOptions;
import dev.openfga.sdk.api.configuration.ClientListObjectsOptions;
import dev.openfga.sdk.api.configuration.ClientListRelationsOptions;
import dev.openfga.sdk.api.configuration.ClientListStoresOptions;
import dev.openfga.sdk.api.configuration.ClientListUsersOptions;
import dev.openfga.sdk.api.configuration.ClientReadAssertionsOptions;
import dev.openfga.sdk.api.configuration.ClientReadAuthorizationModelOptions;
import dev.openfga.sdk.api.configuration.ClientReadAuthorizationModelsOptions;
import dev.openfga.sdk.api.configuration.ClientReadChangesOptions;
import dev.openfga.sdk.api.configuration.ClientReadLatestAuthorizationModelOptions;
import dev.openfga.sdk.api.configuration.ClientReadOptions;
import dev.openfga.sdk.api.configuration.ClientWriteAssertionsOptions;
import dev.openfga.sdk.api.configuration.ClientWriteAuthorizationModelOptions;
import dev.openfga.sdk.api.configuration.ClientWriteOptions;
import dev.openfga.sdk.api.configuration.ClientWriteTuplesOptions;
import dev.openfga.sdk.api.configuration.ConfigurationOverride;
import dev.openfga.sdk.api.model.CheckRequest;
import dev.openfga.sdk.api.model.ContextualTupleKeys;
import dev.openfga.sdk.api.model.CreateStoreRequest;
import dev.openfga.sdk.api.model.ExpandRequest;
import dev.openfga.sdk.api.model.ExpandRequestTupleKey;
import dev.openfga.sdk.api.model.ListObjectsRequest;
import dev.openfga.sdk.api.model.ListUsersRequest;
import dev.openfga.sdk.api.model.ReadRequest;
import dev.openfga.sdk.api.model.ReadRequestTupleKey;
import dev.openfga.sdk.api.model.WriteAssertionsRequest;
import dev.openfga.sdk.api.model.WriteAuthorizationModelRequest;
import dev.openfga.sdk.api.model.WriteRequest;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenFgaClient {
    private final ApiClient apiClient;
    private ClientConfiguration configuration;
    private OpenFgaApi api;
    private static final String CLIENT_BULK_REQUEST_ID_HEADER = "X-OpenFGA-Client-Bulk-Request-Id";
    private static final String CLIENT_METHOD_HEADER = "X-OpenFGA-Client-Method";
    private static final int DEFAULT_MAX_METHOD_PARALLEL_REQS = 10;

    public OpenFgaClient(ClientConfiguration configuration) throws FgaInvalidParameterException {
        this(configuration, new ApiClient());
    }

    public OpenFgaClient(ClientConfiguration configuration, ApiClient apiClient) throws FgaInvalidParameterException {
        this.apiClient = apiClient;
        this.configuration = configuration;
        this.api = new OpenFgaApi(configuration, apiClient);
    }

    public void setStoreId(String storeId) {
        this.configuration.storeId(storeId);
    }

    public void setAuthorizationModelId(String authorizationModelId) {
        this.configuration.authorizationModelId(authorizationModelId);
    }

    public void setConfiguration(ClientConfiguration configuration) throws FgaInvalidParameterException {
        this.configuration = configuration;
        this.api = new OpenFgaApi(configuration, this.apiClient);
    }

    public CompletableFuture<ClientListStoresResponse> listStores() throws FgaInvalidParameterException {
        this.configuration.assertValid();
        return this.call(() -> this.api.listStores(null, null)).thenApply(ClientListStoresResponse::new);
    }

    public CompletableFuture<ClientListStoresResponse> listStores(ClientListStoresOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.listStores(options.getPageSize(), options.getContinuationToken(), overrides)).thenApply(ClientListStoresResponse::new);
    }

    public CompletableFuture<ClientCreateStoreResponse> createStore(CreateStoreRequest request) throws FgaInvalidParameterException {
        return this.createStore(request, null);
    }

    public CompletableFuture<ClientCreateStoreResponse> createStore(CreateStoreRequest request, ClientCreateStoreOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.createStore(request, overrides)).thenApply(ClientCreateStoreResponse::new);
    }

    public CompletableFuture<ClientGetStoreResponse> getStore() throws FgaInvalidParameterException {
        return this.getStore(null);
    }

    public CompletableFuture<ClientGetStoreResponse> getStore(ClientGetStoreOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.getStore(storeId, overrides)).thenApply(ClientGetStoreResponse::new);
    }

    public CompletableFuture<ClientDeleteStoreResponse> deleteStore() throws FgaInvalidParameterException {
        return this.deleteStore(null);
    }

    public CompletableFuture<ClientDeleteStoreResponse> deleteStore(ClientDeleteStoreOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.deleteStore(storeId, overrides)).thenApply(ClientDeleteStoreResponse::new);
    }

    public CompletableFuture<ClientReadAuthorizationModelsResponse> readAuthorizationModels() throws FgaInvalidParameterException {
        return this.readAuthorizationModels(null);
    }

    public CompletableFuture<ClientReadAuthorizationModelsResponse> readAuthorizationModels(ClientReadAuthorizationModelsOptions options) throws FgaInvalidParameterException {
        String continuationToken;
        Integer pageSize;
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        if (options != null) {
            pageSize = options.getPageSize();
            continuationToken = options.getContinuationToken();
        } else {
            continuationToken = null;
            pageSize = null;
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.readAuthorizationModels(storeId, pageSize, continuationToken, overrides)).thenApply(ClientReadAuthorizationModelsResponse::new);
    }

    public CompletableFuture<ClientWriteAuthorizationModelResponse> writeAuthorizationModel(WriteAuthorizationModelRequest request) throws FgaInvalidParameterException {
        return this.writeAuthorizationModel(request, null);
    }

    public CompletableFuture<ClientWriteAuthorizationModelResponse> writeAuthorizationModel(WriteAuthorizationModelRequest request, ClientWriteAuthorizationModelOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.writeAuthorizationModel(storeId, request, overrides)).thenApply(ClientWriteAuthorizationModelResponse::new);
    }

    public CompletableFuture<ClientReadAuthorizationModelResponse> readAuthorizationModel() throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        String authorizationModelId = this.configuration.getAuthorizationModelIdChecked();
        return this.call(() -> this.api.readAuthorizationModel(storeId, authorizationModelId)).thenApply(ClientReadAuthorizationModelResponse::new);
    }

    public CompletableFuture<ClientReadAuthorizationModelResponse> readAuthorizationModel(ClientReadAuthorizationModelOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        String authorizationModelId = options.getAuthorizationModelIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.readAuthorizationModel(storeId, authorizationModelId, overrides)).thenApply(ClientReadAuthorizationModelResponse::new);
    }

    public CompletableFuture<ClientReadAuthorizationModelResponse> readLatestAuthorizationModel() throws FgaInvalidParameterException {
        return this.readLatestAuthorizationModel(null);
    }

    public CompletableFuture<ClientReadAuthorizationModelResponse> readLatestAuthorizationModel(ClientReadLatestAuthorizationModelOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.readAuthorizationModels(storeId, (Integer)1, null, overrides)).thenApply(ClientReadAuthorizationModelResponse::latestOf);
    }

    public CompletableFuture<ClientReadChangesResponse> readChanges(ClientReadChangesRequest request) throws FgaInvalidParameterException {
        return this.readChanges(request, null);
    }

    public CompletableFuture<ClientReadChangesResponse> readChanges(ClientReadChangesRequest request, ClientReadChangesOptions readChangesOptions) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ClientReadChangesOptions options = readChangesOptions != null ? readChangesOptions : new ClientReadChangesOptions();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.readChanges(storeId, request.getType(), options.getPageSize(), options.getContinuationToken(), overrides)).thenApply(ClientReadChangesResponse::new);
    }

    public CompletableFuture<ClientReadResponse> read(ClientReadRequest request) throws FgaInvalidParameterException {
        return this.read(request, null);
    }

    public CompletableFuture<ClientReadResponse> read(ClientReadRequest request, ClientReadOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ReadRequest body = new ReadRequest();
        if (request != null && (request.getUser() != null || request.getRelation() != null || request.getObject() != null)) {
            body.tupleKey(new ReadRequestTupleKey().user(request.getUser()).relation(request.getRelation())._object(request.getObject()));
        }
        if (options != null) {
            body.pageSize(options.getPageSize()).continuationToken(options.getContinuationToken());
            if (options.getConsistency() != null) {
                body.consistency(options.getConsistency());
            }
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.read(storeId, body, overrides)).thenApply(ClientReadResponse::new);
    }

    public CompletableFuture<ClientWriteResponse> write(ClientWriteRequest request) throws FgaInvalidParameterException {
        return this.write(request, null);
    }

    public CompletableFuture<ClientWriteResponse> write(ClientWriteRequest request, ClientWriteOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        if (options != null && options.disableTransactions()) {
            return this.writeNonTransaction(storeId, request, options);
        }
        return this.writeTransactions(storeId, request, options);
    }

    private CompletableFuture<ClientWriteResponse> writeTransactions(String storeId, ClientWriteRequest request, ClientWriteOptions options) {
        List<ClientTupleKeyWithoutCondition> deleteTuples;
        WriteRequest body = new WriteRequest();
        List<ClientTupleKey> writeTuples = request.getWrites();
        if (writeTuples != null && !writeTuples.isEmpty()) {
            body.writes(ClientTupleKey.asWriteRequestWrites(writeTuples));
        }
        if ((deleteTuples = request.getDeletes()) != null && !deleteTuples.isEmpty()) {
            body.deletes(ClientTupleKeyWithoutCondition.asWriteRequestDeletes(deleteTuples));
        }
        if (options != null && !StringUtil.isNullOrWhitespace(options.getAuthorizationModelId())) {
            body.authorizationModelId(options.getAuthorizationModelId());
        } else {
            String authorizationModelId = this.configuration.getAuthorizationModelId();
            body.authorizationModelId(authorizationModelId);
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.write(storeId, body, overrides)).thenApply(ClientWriteResponse::new);
    }

    private CompletableFuture<ClientWriteResponse> writeNonTransaction(String storeId, ClientWriteRequest request, ClientWriteOptions writeOptions) {
        ClientWriteOptions options;
        ClientWriteOptions clientWriteOptions = options = writeOptions != null ? writeOptions : new ClientWriteOptions().transactionChunkSize(10);
        if (options.getAdditionalHeaders() == null) {
            options.additionalHeaders(new HashMap<String, String>());
        }
        options.getAdditionalHeaders().putIfAbsent(CLIENT_METHOD_HEADER, "Write");
        options.getAdditionalHeaders().putIfAbsent(CLIENT_BULK_REQUEST_ID_HEADER, UUID.randomUUID().toString());
        int chunkSize = options.getTransactionChunkSize();
        Stream<ClientWriteRequest> writeTransactions = this.chunksOf(chunkSize, request.getWrites()).map(ClientWriteRequest::ofWrites);
        Stream<ClientWriteRequest> deleteTransactions = this.chunksOf(chunkSize, request.getDeletes()).map(ClientWriteRequest::ofDeletes);
        List transactions = Stream.concat(writeTransactions, deleteTransactions).collect(Collectors.toList());
        if (transactions.isEmpty()) {
            ClientWriteRequest emptyTransaction = new ClientWriteRequest().writes(null).deletes(null);
            return this.writeTransactions(storeId, emptyTransaction, writeOptions);
        }
        CompletionStage<ClientWriteResponse> futureResponse = this.writeTransactions(storeId, (ClientWriteRequest)transactions.get(0), options);
        int i = 1;
        while (i < transactions.size()) {
            int index = i++;
            futureResponse = futureResponse.thenCompose(_response -> this.writeTransactions(storeId, (ClientWriteRequest)transactions.get(index), options));
        }
        return futureResponse;
    }

    private <T> Stream<List<T>> chunksOf(int chunkSize, List<T> list) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        int nChunks = (int)Math.ceil((double)list.size() / (double)chunkSize);
        int finalEndExclusive = list.size();
        Stream.Builder<List<T>> chunks = Stream.builder();
        for (int i = 0; i < nChunks; ++i) {
            List<T> chunk = list.subList(i * chunkSize, Math.min((i + 1) * chunkSize, finalEndExclusive));
            chunks.add(chunk);
        }
        return chunks.build();
    }

    public CompletableFuture<ClientWriteResponse> writeTuples(List<ClientTupleKey> tupleKeys) throws FgaInvalidParameterException {
        return this.writeTuples(tupleKeys, null);
    }

    public CompletableFuture<ClientWriteResponse> writeTuples(List<ClientTupleKey> tupleKeys, ClientWriteTuplesOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        WriteRequest body = new WriteRequest();
        body.writes(ClientTupleKey.asWriteRequestWrites(tupleKeys));
        String authorizationModelId = this.configuration.getAuthorizationModelId();
        if (!StringUtil.isNullOrWhitespace(authorizationModelId)) {
            body.authorizationModelId(authorizationModelId);
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.write(storeId, body, overrides)).thenApply(ClientWriteResponse::new);
    }

    public CompletableFuture<ClientWriteResponse> deleteTuples(List<ClientTupleKeyWithoutCondition> tupleKeys) throws FgaInvalidParameterException {
        return this.deleteTuples(tupleKeys, null);
    }

    public CompletableFuture<ClientWriteResponse> deleteTuples(List<ClientTupleKeyWithoutCondition> tupleKeys, ClientDeleteTuplesOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        WriteRequest body = new WriteRequest();
        body.deletes(ClientTupleKeyWithoutCondition.asWriteRequestDeletes(tupleKeys));
        String authorizationModelId = this.configuration.getAuthorizationModelId();
        if (!StringUtil.isNullOrWhitespace(authorizationModelId)) {
            body.authorizationModelId(authorizationModelId);
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.write(storeId, body, overrides)).thenApply(ClientWriteResponse::new);
    }

    public CompletableFuture<ClientCheckResponse> check(ClientCheckRequest request) throws FgaInvalidParameterException {
        return this.check(request, null);
    }

    public CompletableFuture<ClientCheckResponse> check(ClientCheckRequest request, ClientCheckOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        CheckRequest body = request.asCheckRequest();
        if (options != null) {
            if (options.getConsistency() != null) {
                body.consistency(options.getConsistency());
            }
            String authorizationModelId = !StringUtil.isNullOrWhitespace(options.getAuthorizationModelId()) ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelId();
            body.authorizationModelId(authorizationModelId);
        } else {
            body.setAuthorizationModelId(this.configuration.getAuthorizationModelId());
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.check(storeId, body, overrides)).thenApply(ClientCheckResponse::new);
    }

    public CompletableFuture<List<ClientBatchCheckResponse>> batchCheck(List<ClientCheckRequest> requests) throws FgaInvalidParameterException {
        return this.batchCheck(requests, null);
    }

    public CompletableFuture<List<ClientBatchCheckResponse>> batchCheck(List<ClientCheckRequest> requests, ClientBatchCheckOptions batchCheckOptions) throws FgaInvalidParameterException {
        ClientBatchCheckOptions options;
        this.configuration.assertValid();
        this.configuration.assertValidStoreId();
        ClientBatchCheckOptions clientBatchCheckOptions = options = batchCheckOptions != null ? batchCheckOptions : new ClientBatchCheckOptions().maxParallelRequests(10);
        if (options.getAdditionalHeaders() == null) {
            options.additionalHeaders(new HashMap<String, String>());
        }
        options.getAdditionalHeaders().putIfAbsent(CLIENT_METHOD_HEADER, "BatchCheck");
        options.getAdditionalHeaders().putIfAbsent(CLIENT_BULK_REQUEST_ID_HEADER, UUID.randomUUID().toString());
        int maxParallelRequests = options.getMaxParallelRequests() != null ? options.getMaxParallelRequests() : 10;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(maxParallelRequests);
        CountDownLatch latch = new CountDownLatch(requests.size());
        ConcurrentLinkedQueue responses = new ConcurrentLinkedQueue();
        ClientCheckOptions clientCheckOptions = options.asClientCheckOptions();
        Consumer<ClientCheckRequest> singleClientCheckRequest = request -> ((CompletableFuture)((CompletableFuture)this.call(() -> this.check((ClientCheckRequest)request, clientCheckOptions)).handleAsync(ClientBatchCheckResponse.asyncHandler(request))).thenAccept(responses::add)).thenRun(latch::countDown);
        try {
            requests.forEach(request -> executor.execute(() -> singleClientCheckRequest.accept((ClientCheckRequest)request)));
            latch.await();
            return CompletableFuture.completedFuture(new ArrayList(responses));
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ClientExpandResponse> expand(ClientExpandRequest request) throws FgaInvalidParameterException {
        return this.expand(request, null);
    }

    public CompletableFuture<ClientExpandResponse> expand(ClientExpandRequest request, ClientExpandOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ExpandRequest body = new ExpandRequest();
        if (request != null) {
            body.tupleKey(new ExpandRequestTupleKey().relation(request.getRelation())._object(request.getObject()));
        }
        if (options != null) {
            if (options.getConsistency() != null) {
                body.consistency(options.getConsistency());
            }
            String authorizationModelId = !StringUtil.isNullOrWhitespace(options.getAuthorizationModelId()) ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelId();
            body.authorizationModelId(authorizationModelId);
        } else {
            body.setAuthorizationModelId(this.configuration.getAuthorizationModelId());
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.expand(storeId, body, overrides)).thenApply(ClientExpandResponse::new);
    }

    public CompletableFuture<ClientListObjectsResponse> listObjects(ClientListObjectsRequest request) throws FgaInvalidParameterException {
        return this.listObjects(request, null);
    }

    public CompletableFuture<ClientListObjectsResponse> listObjects(ClientListObjectsRequest request, ClientListObjectsOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ListObjectsRequest body = new ListObjectsRequest();
        if (request != null) {
            body.user(request.getUser()).relation(request.getRelation()).type(request.getType());
            if (request.getContextualTupleKeys() != null) {
                List<ClientTupleKey> contextualTuples = request.getContextualTupleKeys();
                ContextualTupleKeys bodyContextualTuples = ClientTupleKey.asContextualTupleKeys(contextualTuples);
                body.contextualTuples(bodyContextualTuples);
            }
            if (request.getContext() != null) {
                body.context(request.getContext());
            }
        }
        if (options != null) {
            if (options.getConsistency() != null) {
                body.consistency(options.getConsistency());
            }
            String authorizationModelId = !StringUtil.isNullOrWhitespace(options.getAuthorizationModelId()) ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelId();
            body.authorizationModelId(authorizationModelId);
        } else {
            body.setAuthorizationModelId(this.configuration.getAuthorizationModelId());
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.listObjects(storeId, body, overrides)).thenApply(ClientListObjectsResponse::new);
    }

    public CompletableFuture<ClientListRelationsResponse> listRelations(ClientListRelationsRequest request) throws FgaInvalidParameterException {
        return this.listRelations(request, null);
    }

    public CompletableFuture<ClientListRelationsResponse> listRelations(ClientListRelationsRequest request, ClientListRelationsOptions listRelationsOptions) throws FgaInvalidParameterException {
        ClientListRelationsOptions options;
        if (request.getRelations() == null || request.getRelations().isEmpty()) {
            throw new FgaInvalidParameterException("At least 1 relation to check has to be provided when calling ListRelations");
        }
        ClientListRelationsOptions clientListRelationsOptions = options = listRelationsOptions != null ? listRelationsOptions : new ClientListRelationsOptions().maxParallelRequests(10);
        if (options.getAdditionalHeaders() == null) {
            options.additionalHeaders(new HashMap<String, String>());
        }
        options.getAdditionalHeaders().putIfAbsent(CLIENT_METHOD_HEADER, "ListRelations");
        options.getAdditionalHeaders().putIfAbsent(CLIENT_BULK_REQUEST_ID_HEADER, UUID.randomUUID().toString());
        List<ClientCheckRequest> batchCheckRequests = request.getRelations().stream().map(relation -> new ClientCheckRequest().user(request.getUser()).relation((String)relation)._object(request.getObject()).contextualTuples(request.getContextualTupleKeys()).context(request.getContext())).collect(Collectors.toList());
        return this.batchCheck(batchCheckRequests, options.asClientBatchCheckOptions()).thenCompose(responses -> this.call(() -> ClientListRelationsResponse.fromBatchCheckResponses(responses)));
    }

    public CompletableFuture<ClientListUsersResponse> listUsers(ClientListUsersRequest request) throws FgaInvalidParameterException {
        return this.listUsers(request, null);
    }

    public CompletableFuture<ClientListUsersResponse> listUsers(ClientListUsersRequest request, ClientListUsersOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        ListUsersRequest body = new ListUsersRequest();
        if (request != null) {
            body._object(request.getObject()).relation(request.getRelation()).userFilters(request.getUserFilters());
            if (request.getContextualTupleKeys() != null) {
                List<ClientTupleKey> contextualTuples = request.getContextualTupleKeys();
                ContextualTupleKeys bodyContextualTuples = ClientTupleKey.asContextualTupleKeys(contextualTuples);
                body.contextualTuples(bodyContextualTuples.getTupleKeys());
            }
            if (request.getContext() != null) {
                body.context(request.getContext());
            }
        }
        if (options != null) {
            if (options.getConsistency() != null) {
                body.consistency(options.getConsistency());
            }
            String authorizationModelId = !StringUtil.isNullOrWhitespace(options.getAuthorizationModelId()) ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelId();
            body.authorizationModelId(authorizationModelId);
        } else {
            body.setAuthorizationModelId(this.configuration.getAuthorizationModelId());
        }
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.listUsers(storeId, body, overrides)).thenApply(ClientListUsersResponse::new);
    }

    public CompletableFuture<ClientReadAssertionsResponse> readAssertions() throws FgaInvalidParameterException {
        return this.readAssertions(null);
    }

    public CompletableFuture<ClientReadAssertionsResponse> readAssertions(ClientReadAssertionsOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        String authorizationModelId = options != null && options.hasValidAuthorizationModelId() ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelIdChecked();
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.readAssertions(storeId, authorizationModelId, overrides)).thenApply(ClientReadAssertionsResponse::new);
    }

    public CompletableFuture<ClientWriteAssertionsResponse> writeAssertions(List<ClientAssertion> assertions) throws FgaInvalidParameterException {
        return this.writeAssertions(assertions, null);
    }

    public CompletableFuture<ClientWriteAssertionsResponse> writeAssertions(List<ClientAssertion> assertions, ClientWriteAssertionsOptions options) throws FgaInvalidParameterException {
        this.configuration.assertValid();
        String storeId = this.configuration.getStoreIdChecked();
        String authorizationModelId = options != null && options.hasValidAuthorizationModelId() ? options.getAuthorizationModelId() : this.configuration.getAuthorizationModelIdChecked();
        WriteAssertionsRequest body = new WriteAssertionsRequest().assertions(ClientAssertion.asAssertions(assertions));
        ConfigurationOverride overrides = new ConfigurationOverride().addHeaders(options);
        return this.call(() -> this.api.writeAssertions(storeId, authorizationModelId, body, overrides)).thenApply(ClientWriteAssertionsResponse::new);
    }

    private <T> CompletableFuture<T> call(CheckedAsyncInvocation<T> action) {
        try {
            return action.call();
        }
        catch (CompletionException completionException) {
            return CompletableFuture.failedFuture(completionException.getCause());
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    private <T> CompletableFuture<T> call(CheckedInvocation<T> action) {
        try {
            return CompletableFuture.completedFuture(action.call());
        }
        catch (CompletionException completionException) {
            return CompletableFuture.failedFuture(completionException.getCause());
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    @FunctionalInterface
    private static interface CheckedInvocation<R> {
        public R call() throws Throwable;
    }

    @FunctionalInterface
    private static interface CheckedAsyncInvocation<R> {
        public CompletableFuture<R> call() throws Throwable;
    }
}

