/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.configuration;

import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.util.Validation;

public class ClientCredentials {
    private String clientId;
    private String clientSecret;
    private String apiTokenIssuer;
    private String apiAudience;
    private String scopes;

    public ClientCredentials clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public void assertValid() throws FgaInvalidParameterException {
        Validation.assertParamExists(this.clientId, "clientId", "ClientCredentials");
        Validation.assertParamExists(this.clientSecret, "clientSecret", "ClientCredentials");
        Validation.assertParamExists(this.apiTokenIssuer, "apiTokenIssuer", "ClientCredentials");
        Validation.assertParamExists(this.apiAudience, "apiAudience", "ClientCredentials");
    }

    public String getClientId() {
        return this.clientId;
    }

    public ClientCredentials clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public ClientCredentials apiTokenIssuer(String apiTokenIssuer) {
        this.apiTokenIssuer = apiTokenIssuer;
        return this;
    }

    public String getApiTokenIssuer() {
        return this.apiTokenIssuer;
    }

    public ClientCredentials apiAudience(String apiAudience) {
        this.apiAudience = apiAudience;
        return this;
    }

    public String getApiAudience() {
        return this.apiAudience;
    }

    public ClientCredentials scopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getScopes() {
        return this.scopes;
    }
}

