/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.AssertionTupleKey;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"tuple_key", "expectation"})
public class Assertion {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    private AssertionTupleKey tupleKey;
    public static final String JSON_PROPERTY_EXPECTATION = "expectation";
    private Boolean expectation;

    public Assertion tupleKey(AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AssertionTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public Assertion expectation(Boolean expectation) {
        this.expectation = expectation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getExpectation() {
        return this.expectation;
    }

    @JsonProperty(value="expectation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setExpectation(Boolean expectation) {
        this.expectation = expectation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Assertion assertion = (Assertion)o;
        return Objects.equals(this.tupleKey, assertion.tupleKey) && Objects.equals(this.expectation, assertion.expectation);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.expectation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Assertion {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    expectation: ").append(this.toIndentedString(this.expectation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getExpectation() != null) {
            joiner.add(String.format("%sexpectation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getExpectation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

