/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.Assertion;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authorization_model_id", "assertions"})
public class ReadAssertionsResponse {
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;
    public static final String JSON_PROPERTY_ASSERTIONS = "assertions";
    private List<Assertion> assertions = new ArrayList<Assertion>();

    public ReadAssertionsResponse authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ReadAssertionsResponse assertions(List<Assertion> assertions) {
        this.assertions = assertions;
        return this;
    }

    public ReadAssertionsResponse addAssertionsItem(Assertion assertionsItem) {
        if (this.assertions == null) {
            this.assertions = new ArrayList<Assertion>();
        }
        this.assertions.add(assertionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Assertion> getAssertions() {
        return this.assertions;
    }

    @JsonProperty(value="assertions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssertions(List<Assertion> assertions) {
        this.assertions = assertions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAssertionsResponse readAssertionsResponse = (ReadAssertionsResponse)o;
        return Objects.equals(this.authorizationModelId, readAssertionsResponse.authorizationModelId) && Objects.equals(this.assertions, readAssertionsResponse.assertions);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationModelId, this.assertions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadAssertionsResponse {\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    assertions: ").append(this.toIndentedString(this.assertions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorizationModelId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAssertions() != null) {
            for (int i = 0; i < this.getAssertions().size(); ++i) {
                if (this.getAssertions().get(i) == null) continue;
                joiner.add(this.getAssertions().get(i).toUrlQueryString(String.format("%sassertions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

