/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.TupleChange;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"changes", "continuation_token"})
public class ReadChangesResponse {
    public static final String JSON_PROPERTY_CHANGES = "changes";
    private List<TupleChange> changes = new ArrayList<TupleChange>();
    public static final String JSON_PROPERTY_CONTINUATION_TOKEN = "continuation_token";
    private String continuationToken;

    public ReadChangesResponse changes(List<TupleChange> changes) {
        this.changes = changes;
        return this;
    }

    public ReadChangesResponse addChangesItem(TupleChange changesItem) {
        if (this.changes == null) {
            this.changes = new ArrayList<TupleChange>();
        }
        this.changes.add(changesItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<TupleChange> getChanges() {
        return this.changes;
    }

    @JsonProperty(value="changes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChanges(List<TupleChange> changes) {
        this.changes = changes;
    }

    public ReadChangesResponse continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadChangesResponse readChangesResponse = (ReadChangesResponse)o;
        return Objects.equals(this.changes, readChangesResponse.changes) && Objects.equals(this.continuationToken, readChangesResponse.continuationToken);
    }

    public int hashCode() {
        return Objects.hash(this.changes, this.continuationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadChangesResponse {\n");
        sb.append("    changes: ").append(this.toIndentedString(this.changes)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getChanges() != null) {
            for (int i = 0; i < this.getChanges().size(); ++i) {
                if (this.getChanges().get(i) == null) continue;
                joiner.add(this.getChanges().get(i).toUrlQueryString(String.format("%schanges%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContinuationToken() != null) {
            joiner.add(String.format("%scontinuation_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContinuationToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

