/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.errors;

import dev.openfga.sdk.api.configuration.ClientCredentials;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.api.configuration.Credentials;
import dev.openfga.sdk.api.configuration.CredentialsMethod;
import dev.openfga.sdk.errors.ApiException;
import dev.openfga.sdk.errors.FgaApiAuthenticationError;
import dev.openfga.sdk.errors.FgaApiInternalError;
import dev.openfga.sdk.errors.FgaApiNotFoundError;
import dev.openfga.sdk.errors.FgaApiRateLimitExceededError;
import dev.openfga.sdk.errors.FgaApiValidationError;
import dev.openfga.sdk.errors.HttpStatusCode;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;

public class FgaError
extends ApiException {
    private String method = null;
    private String requestUrl = null;
    private String clientId = null;
    private String audience = null;
    private String grantType = null;
    private String requestId = null;
    private String apiErrorCode = null;

    public FgaError(String message, Throwable cause, int code, HttpHeaders responseHeaders, String responseBody) {
        super(message, cause, code, responseHeaders, responseBody);
    }

    public FgaError(String message, int code, HttpHeaders responseHeaders, String responseBody) {
        super(message, code, responseHeaders, responseBody);
    }

    public static Optional<FgaError> getError(String name, HttpRequest request, Configuration configuration, HttpResponse<String> response, Throwable previousError) {
        int status = response.statusCode();
        if (HttpStatusCode.isSuccessful(status)) {
            return Optional.empty();
        }
        String body = response.body();
        HttpHeaders headers = response.headers();
        FgaError error = status == 400 || status == 422 ? new FgaApiValidationError(name, previousError, status, headers, body) : (status == 401 || status == 403 ? new FgaApiAuthenticationError(name, previousError, status, headers, body) : (status == 404 ? new FgaApiNotFoundError(name, previousError, status, headers, body) : (status == 429 ? new FgaApiRateLimitExceededError(name, previousError, status, headers, body) : (HttpStatusCode.isServerError(status) ? new FgaApiInternalError(name, previousError, status, headers, body) : new FgaError(name, previousError, status, headers, body)))));
        error.setMethod(request.method());
        error.setRequestUrl(configuration.getApiUrl());
        Credentials credentials = configuration.getCredentials();
        if (CredentialsMethod.CLIENT_CREDENTIALS == credentials.getCredentialsMethod()) {
            ClientCredentials clientCredentials = credentials.getClientCredentials();
            error.setClientId(clientCredentials.getClientId());
            error.setAudience(clientCredentials.getApiAudience());
        }
        return Optional.of(error);
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setApiErrorCode(String apiErrorCode) {
        this.apiErrorCode = apiErrorCode;
    }

    public String getApiErrorCode() {
        return this.apiErrorCode;
    }
}

