/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api;

import static dev.openfga.sdk.util.StringUtil.isNullOrWhitespace;
import static dev.openfga.sdk.util.Validation.assertParamExists;

import dev.openfga.sdk.api.auth.*;
import dev.openfga.sdk.api.client.*;
import dev.openfga.sdk.api.configuration.*;
import dev.openfga.sdk.api.model.CheckRequest;
import dev.openfga.sdk.api.model.CheckResponse;
import dev.openfga.sdk.api.model.CreateStoreRequest;
import dev.openfga.sdk.api.model.CreateStoreResponse;
import dev.openfga.sdk.api.model.ExpandRequest;
import dev.openfga.sdk.api.model.ExpandResponse;
import dev.openfga.sdk.api.model.GetStoreResponse;
import dev.openfga.sdk.api.model.ListObjectsRequest;
import dev.openfga.sdk.api.model.ListObjectsResponse;
import dev.openfga.sdk.api.model.ListStoresResponse;
import dev.openfga.sdk.api.model.ListUsersRequest;
import dev.openfga.sdk.api.model.ListUsersResponse;
import dev.openfga.sdk.api.model.ReadAssertionsResponse;
import dev.openfga.sdk.api.model.ReadAuthorizationModelResponse;
import dev.openfga.sdk.api.model.ReadAuthorizationModelsResponse;
import dev.openfga.sdk.api.model.ReadChangesResponse;
import dev.openfga.sdk.api.model.ReadRequest;
import dev.openfga.sdk.api.model.ReadResponse;
import dev.openfga.sdk.api.model.WriteAssertionsRequest;
import dev.openfga.sdk.api.model.WriteAuthorizationModelRequest;
import dev.openfga.sdk.api.model.WriteAuthorizationModelResponse;
import dev.openfga.sdk.api.model.WriteRequest;
import dev.openfga.sdk.errors.*;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Attributes;
import dev.openfga.sdk.telemetry.Telemetry;
import dev.openfga.sdk.util.Pair;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * A low-level API representation of an OpenFGA server.
 * <p>
 * Most code should favor the simpler and higher-level {@link OpenFgaClient} when calling an OpenFGA server.
 */
public class OpenFgaApi {
    private final Configuration configuration;

    private final ApiClient apiClient;
    private final OAuth2Client oAuth2Client;
    private final Telemetry telemetry;

    public OpenFgaApi(Configuration configuration) throws FgaInvalidParameterException {
        this(configuration, new ApiClient());
    }

    public OpenFgaApi(Configuration configuration, ApiClient apiClient) throws FgaInvalidParameterException {
        this.apiClient = apiClient;
        this.configuration = configuration;
        this.telemetry = new Telemetry(this.configuration);

        if (configuration.getCredentials().getCredentialsMethod() == CredentialsMethod.CLIENT_CREDENTIALS) {
            this.oAuth2Client = new OAuth2Client(configuration, apiClient);
        } else {
            this.oAuth2Client = null;
        }

        var defaultHeaders = configuration.getDefaultHeaders();
        if (defaultHeaders != null) {
            apiClient.addRequestInterceptor(httpRequest -> defaultHeaders.forEach(httpRequest::setHeader));
        }
    }

    /**
     * Check whether a user is authorized to access an object
     * The Check API returns whether a given user has a relationship with a given object in a given store. The &#x60;user&#x60; field of the request can be a specific target, such as &#x60;user:anne&#x60;, or a userset (set of users) such as &#x60;group:marketing#member&#x60; or a type-bound public access &#x60;user:*&#x60;. To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). A &#x60;contextual_tuples&#x60; object may also be included in the body of the request. This object contains one field &#x60;tuple_keys&#x60;, which is an array of tuple keys. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide an &#x60;authorization_model_id&#x60; in the body. This will be used to assert that the input &#x60;tuple_key&#x60; is valid for the model specified. If not specified, the assertion will be made against the latest authorization model ID. It is strongly recommended to specify authorization model id for better performance. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will return whether the relationship exists in the field &#x60;allowed&#x60;.  Some exceptions apply, but in general, if a Check API responds with &#x60;{allowed: true}&#x60;, then you can expect the equivalent ListObjects query to return the object, and viceversa.  For example, if &#x60;Check(user:anne, reader, document:2021-budget)&#x60; responds with &#x60;{allowed: true}&#x60;, then &#x60;ListObjects(user:anne, reader, document)&#x60; may include &#x60;document:2021-budget&#x60; in the response. ## Examples ### Querying with contextual tuples In order to check if user &#x60;user:anne&#x60; of type &#x60;user&#x60; has a &#x60;reader&#x60; relationship with object &#x60;document:2021-budget&#x60; given the following contextual tuple &#x60;&#x60;&#x60;json {   \&quot;user\&quot;: \&quot;user:anne\&quot;,   \&quot;relation\&quot;: \&quot;member\&quot;,   \&quot;object\&quot;: \&quot;time_slot:office_hours\&quot; } &#x60;&#x60;&#x60; the Check API can be used with the following request body: &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {     \&quot;user\&quot;: \&quot;user:anne\&quot;,     \&quot;relation\&quot;: \&quot;reader\&quot;,     \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   },   \&quot;contextual_tuples\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;member\&quot;,         \&quot;object\&quot;: \&quot;time_slot:office_hours\&quot;       }     ]   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; ### Querying usersets Some Checks will always return &#x60;true&#x60;, even without any tuples. For example, for the following authorization model &#x60;&#x60;&#x60;python model   schema 1.1 type user type document   relations     define reader: [user] &#x60;&#x60;&#x60; the following query &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;document:2021-budget#reader\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   } } &#x60;&#x60;&#x60; will always return &#x60;{ \&quot;allowed\&quot;: true }&#x60;. This is because usersets are self-defining: the userset &#x60;document:2021-budget#reader&#x60; will always have the &#x60;reader&#x60; relation with &#x60;document:2021-budget&#x60;. ### Querying usersets with difference in the model A Check for a userset can yield results that must be treated carefully if the model involves difference. For example, for the following authorization model &#x60;&#x60;&#x60;python model   schema 1.1 type user type group   relations     define member: [user] type document   relations     define blocked: [user]     define reader: [group#member] but not blocked &#x60;&#x60;&#x60; the following query &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;group:finance#member\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   },   \&quot;contextual_tuples\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;member\&quot;,         \&quot;object\&quot;: \&quot;group:finance\&quot;       },       {         \&quot;user\&quot;: \&quot;group:finance#member\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;blocked\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   }, } &#x60;&#x60;&#x60; will return &#x60;{ \&quot;allowed\&quot;: true }&#x60;, even though a specific user of the userset &#x60;group:finance#member&#x60; does not have the &#x60;reader&#x60; relationship with the given object.
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;CheckResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<CheckResponse>> check(String storeId, CheckRequest body)
            throws ApiException, FgaInvalidParameterException {
        return check(storeId, body, this.configuration);
    }

    /**
     * Check whether a user is authorized to access an object
     * The Check API returns whether a given user has a relationship with a given object in a given store. The &#x60;user&#x60; field of the request can be a specific target, such as &#x60;user:anne&#x60;, or a userset (set of users) such as &#x60;group:marketing#member&#x60; or a type-bound public access &#x60;user:*&#x60;. To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). A &#x60;contextual_tuples&#x60; object may also be included in the body of the request. This object contains one field &#x60;tuple_keys&#x60;, which is an array of tuple keys. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide an &#x60;authorization_model_id&#x60; in the body. This will be used to assert that the input &#x60;tuple_key&#x60; is valid for the model specified. If not specified, the assertion will be made against the latest authorization model ID. It is strongly recommended to specify authorization model id for better performance. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will return whether the relationship exists in the field &#x60;allowed&#x60;.  Some exceptions apply, but in general, if a Check API responds with &#x60;{allowed: true}&#x60;, then you can expect the equivalent ListObjects query to return the object, and viceversa.  For example, if &#x60;Check(user:anne, reader, document:2021-budget)&#x60; responds with &#x60;{allowed: true}&#x60;, then &#x60;ListObjects(user:anne, reader, document)&#x60; may include &#x60;document:2021-budget&#x60; in the response. ## Examples ### Querying with contextual tuples In order to check if user &#x60;user:anne&#x60; of type &#x60;user&#x60; has a &#x60;reader&#x60; relationship with object &#x60;document:2021-budget&#x60; given the following contextual tuple &#x60;&#x60;&#x60;json {   \&quot;user\&quot;: \&quot;user:anne\&quot;,   \&quot;relation\&quot;: \&quot;member\&quot;,   \&quot;object\&quot;: \&quot;time_slot:office_hours\&quot; } &#x60;&#x60;&#x60; the Check API can be used with the following request body: &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {     \&quot;user\&quot;: \&quot;user:anne\&quot;,     \&quot;relation\&quot;: \&quot;reader\&quot;,     \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   },   \&quot;contextual_tuples\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;member\&quot;,         \&quot;object\&quot;: \&quot;time_slot:office_hours\&quot;       }     ]   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; ### Querying usersets Some Checks will always return &#x60;true&#x60;, even without any tuples. For example, for the following authorization model &#x60;&#x60;&#x60;python model   schema 1.1 type user type document   relations     define reader: [user] &#x60;&#x60;&#x60; the following query &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;document:2021-budget#reader\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   } } &#x60;&#x60;&#x60; will always return &#x60;{ \&quot;allowed\&quot;: true }&#x60;. This is because usersets are self-defining: the userset &#x60;document:2021-budget#reader&#x60; will always have the &#x60;reader&#x60; relation with &#x60;document:2021-budget&#x60;. ### Querying usersets with difference in the model A Check for a userset can yield results that must be treated carefully if the model involves difference. For example, for the following authorization model &#x60;&#x60;&#x60;python model   schema 1.1 type user type group   relations     define member: [user] type document   relations     define blocked: [user]     define reader: [group#member] but not blocked &#x60;&#x60;&#x60; the following query &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;group:finance#member\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;   },   \&quot;contextual_tuples\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;member\&quot;,         \&quot;object\&quot;: \&quot;group:finance\&quot;       },       {         \&quot;user\&quot;: \&quot;group:finance#member\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;blocked\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   }, } &#x60;&#x60;&#x60; will return &#x60;{ \&quot;allowed\&quot;: true }&#x60;, even though a specific user of the userset &#x60;group:finance#member&#x60; does not have the &#x60;reader&#x60; relationship with the given object.
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;CheckResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<CheckResponse>> check(
            String storeId, CheckRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return check(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<CheckResponse>> check(
            String storeId, CheckRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "check");

        assertParamExists(body, "body", "check");

        String path = "/stores/{store_id}/check".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Check");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "check", CheckResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Create a store
     * Create a unique OpenFGA store which will be used to store authorization models and relationship tuples.
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;CreateStoreResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(CreateStoreRequest body)
            throws ApiException, FgaInvalidParameterException {
        return createStore(body, this.configuration);
    }

    /**
     * Create a store
     * Create a unique OpenFGA store which will be used to store authorization models and relationship tuples.
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;CreateStoreResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(
            CreateStoreRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return createStore(body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(
            CreateStoreRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {

        assertParamExists(body, "body", "createStore");

        String path = "/stores";

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "CreateStore");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "createStore", CreateStoreResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Delete a store
     * Delete an OpenFGA store. This does not delete the data associated with the store, like tuples or authorization models.
     * @param storeId  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;Void&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Void>> deleteStore(String storeId)
            throws ApiException, FgaInvalidParameterException {
        return deleteStore(storeId, this.configuration);
    }

    /**
     * Delete a store
     * Delete an OpenFGA store. This does not delete the data associated with the store, like tuples or authorization models.
     * @param storeId  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;Void&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Void>> deleteStore(String storeId, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return deleteStore(storeId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Void>> deleteStore(String storeId, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "deleteStore");

        String path = "/stores/{store_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "DeleteStore");

        try {
            HttpRequest request = buildHttpRequest("DELETE", path, configuration);
            return new HttpRequestAttempt<>(request, "deleteStore", Void.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Expand all relationships in userset tree format, and following userset rewrite rules.  Useful to reason about and debug a certain relationship
     * The Expand API will return all users and usersets that have certain relationship with an object in a certain store. This is different from the &#x60;/stores/{store_id}/read&#x60; API in that both users and computed usersets are returned. Body parameters &#x60;tuple_key.object&#x60; and &#x60;tuple_key.relation&#x60; are all required. The response will return a tree whose leaves are the specific users and usersets. Union, intersection and difference operator are located in the intermediate nodes.  ## Example To expand all users that have the &#x60;reader&#x60; relationship with object &#x60;document:2021-budget&#x60;, use the Expand API with the following request body &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {     \&quot;object\&quot;: \&quot;document:2021-budget\&quot;,     \&quot;relation\&quot;: \&quot;reader\&quot;   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; OpenFGA&#39;s response will be a userset tree of the users and usersets that have read access to the document. &#x60;&#x60;&#x60;json {   \&quot;tree\&quot;:{     \&quot;root\&quot;:{       \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,       \&quot;union\&quot;:{         \&quot;nodes\&quot;:[           {             \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,             \&quot;leaf\&quot;:{               \&quot;users\&quot;:{                 \&quot;users\&quot;:[                   \&quot;user:bob\&quot;                 ]               }             }           },           {             \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,             \&quot;leaf\&quot;:{               \&quot;computed\&quot;:{                 \&quot;userset\&quot;:\&quot;document:2021-budget#writer\&quot;               }             }           }         ]       }     }   } } &#x60;&#x60;&#x60; The caller can then call expand API for the &#x60;writer&#x60; relationship for the &#x60;document:2021-budget&#x60;.
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ExpandResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ExpandResponse>> expand(String storeId, ExpandRequest body)
            throws ApiException, FgaInvalidParameterException {
        return expand(storeId, body, this.configuration);
    }

    /**
     * Expand all relationships in userset tree format, and following userset rewrite rules.  Useful to reason about and debug a certain relationship
     * The Expand API will return all users and usersets that have certain relationship with an object in a certain store. This is different from the &#x60;/stores/{store_id}/read&#x60; API in that both users and computed usersets are returned. Body parameters &#x60;tuple_key.object&#x60; and &#x60;tuple_key.relation&#x60; are all required. The response will return a tree whose leaves are the specific users and usersets. Union, intersection and difference operator are located in the intermediate nodes.  ## Example To expand all users that have the &#x60;reader&#x60; relationship with object &#x60;document:2021-budget&#x60;, use the Expand API with the following request body &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {     \&quot;object\&quot;: \&quot;document:2021-budget\&quot;,     \&quot;relation\&quot;: \&quot;reader\&quot;   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; OpenFGA&#39;s response will be a userset tree of the users and usersets that have read access to the document. &#x60;&#x60;&#x60;json {   \&quot;tree\&quot;:{     \&quot;root\&quot;:{       \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,       \&quot;union\&quot;:{         \&quot;nodes\&quot;:[           {             \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,             \&quot;leaf\&quot;:{               \&quot;users\&quot;:{                 \&quot;users\&quot;:[                   \&quot;user:bob\&quot;                 ]               }             }           },           {             \&quot;type\&quot;:\&quot;document:2021-budget#reader\&quot;,             \&quot;leaf\&quot;:{               \&quot;computed\&quot;:{                 \&quot;userset\&quot;:\&quot;document:2021-budget#writer\&quot;               }             }           }         ]       }     }   } } &#x60;&#x60;&#x60; The caller can then call expand API for the &#x60;writer&#x60; relationship for the &#x60;document:2021-budget&#x60;.
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ExpandResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ExpandResponse>> expand(
            String storeId, ExpandRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return expand(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ExpandResponse>> expand(
            String storeId, ExpandRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "expand");

        assertParamExists(body, "body", "expand");

        String path = "/stores/{store_id}/expand".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Expand");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "expand", ExpandResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Get a store
     * Returns an OpenFGA store by its identifier
     * @param storeId  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;GetStoreResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<GetStoreResponse>> getStore(String storeId)
            throws ApiException, FgaInvalidParameterException {
        return getStore(storeId, this.configuration);
    }

    /**
     * Get a store
     * Returns an OpenFGA store by its identifier
     * @param storeId  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;GetStoreResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<GetStoreResponse>> getStore(
            String storeId, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return getStore(storeId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<GetStoreResponse>> getStore(String storeId, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "getStore");

        String path = "/stores/{store_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "GetStore");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(request, "getStore", GetStoreResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * List all objects of the given type that the user has a relation with
     * The ListObjects API returns a list of all the objects of the given type that the user has a relation with.  To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). An &#x60;authorization_model_id&#x60; may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance. You may also specify &#x60;contextual_tuples&#x60; that will be treated as regular tuples. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will contain the related objects in an array in the \&quot;objects\&quot; field of the response and they will be strings in the object format &#x60;&lt;type&gt;:&lt;id&gt;&#x60; (e.g. \&quot;document:roadmap\&quot;). The number of objects in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_OBJECTS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_OBJECTS_MAX_RESULTS, whichever is hit first. The objects given will not be sorted, and therefore two identical calls can give a given different set of objects.
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ListObjectsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(String storeId, ListObjectsRequest body)
            throws ApiException, FgaInvalidParameterException {
        return listObjects(storeId, body, this.configuration);
    }

    /**
     * List all objects of the given type that the user has a relation with
     * The ListObjects API returns a list of all the objects of the given type that the user has a relation with.  To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). An &#x60;authorization_model_id&#x60; may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance. You may also specify &#x60;contextual_tuples&#x60; that will be treated as regular tuples. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will contain the related objects in an array in the \&quot;objects\&quot; field of the response and they will be strings in the object format &#x60;&lt;type&gt;:&lt;id&gt;&#x60; (e.g. \&quot;document:roadmap\&quot;). The number of objects in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_OBJECTS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_OBJECTS_MAX_RESULTS, whichever is hit first. The objects given will not be sorted, and therefore two identical calls can give a given different set of objects.
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ListObjectsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(
            String storeId, ListObjectsRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return listObjects(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(
            String storeId, ListObjectsRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "listObjects");

        assertParamExists(body, "body", "listObjects");

        String path = "/stores/{store_id}/list-objects".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListObjects");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "listObjects", ListObjectsResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * List all stores
     * Returns a paginated list of OpenFGA stores and a continuation token to get additional stores. The continuation token will be empty if there are no more stores.
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @return CompletableFuture&lt;ApiResponse&lt;ListStoresResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListStoresResponse>> listStores(Integer pageSize, String continuationToken)
            throws ApiException, FgaInvalidParameterException {
        return listStores(pageSize, continuationToken, this.configuration);
    }

    /**
     * List all stores
     * Returns a paginated list of OpenFGA stores and a continuation token to get additional stores. The continuation token will be empty if there are no more stores.
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ListStoresResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListStoresResponse>> listStores(
            Integer pageSize, String continuationToken, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return listStores(pageSize, continuationToken, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListStoresResponse>> listStores(
            Integer pageSize, String continuationToken, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        String path = "/stores";
        path = pathWithParams(path, "page_size", pageSize, "continuation_token", continuationToken);

        Map<String, Object> methodParameters = new HashMap<>();

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListStores");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(request, "listStores", ListStoresResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * List the users matching the provided filter who have a certain relation to a particular type.
     * The ListUsers API returns a list of all the users of a specific type that have a relation to a given object.  To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). An &#x60;authorization_model_id&#x60; may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance. You may also specify &#x60;contextual_tuples&#x60; that will be treated as regular tuples. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will contain the related users in an array in the \&quot;users\&quot; field of the response. These results may include specific objects, usersets  or type-bound public access. Each of these types of results is encoded in its own type and not represented as a string.In cases where a type-bound public acces result is returned (e.g. &#x60;user:*&#x60;), it cannot be inferred that all subjects of that type have a relation to the object; it is possible that negations exist and checks should still be queried on individual subjects to ensure access to that document.The number of users in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_USERS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_USERS_MAX_RESULTS, whichever is hit first. The returned users will not be sorted, and therefore two identical calls may yield different sets of users.
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ListUsersResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(String storeId, ListUsersRequest body)
            throws ApiException, FgaInvalidParameterException {
        return listUsers(storeId, body, this.configuration);
    }

    /**
     * List the users matching the provided filter who have a certain relation to a particular type.
     * The ListUsers API returns a list of all the users of a specific type that have a relation to a given object.  To arrive at a result, the API uses: an authorization model, explicit tuples written through the Write API, contextual tuples present in the request, and implicit tuples that exist by virtue of applying set theory (such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;; the set of users who are viewers of &#x60;document:2021-budget&#x60; are the set of users who are the viewers of &#x60;document:2021-budget&#x60;). An &#x60;authorization_model_id&#x60; may be specified in the body. If it is not specified, the latest authorization model ID will be used. It is strongly recommended to specify authorization model id for better performance. You may also specify &#x60;contextual_tuples&#x60; that will be treated as regular tuples. Each of these tuples may have an associated &#x60;condition&#x60;. You may also provide a &#x60;context&#x60; object that will be used to evaluate the conditioned tuples in the system. It is strongly recommended to provide a value for all the input parameters of all the conditions, to ensure that all tuples be evaluated correctly. The response will contain the related users in an array in the \&quot;users\&quot; field of the response. These results may include specific objects, usersets  or type-bound public access. Each of these types of results is encoded in its own type and not represented as a string.In cases where a type-bound public acces result is returned (e.g. &#x60;user:*&#x60;), it cannot be inferred that all subjects of that type have a relation to the object; it is possible that negations exist and checks should still be queried on individual subjects to ensure access to that document.The number of users in the response array will be limited by the execution timeout specified in the flag OPENFGA_LIST_USERS_DEADLINE and by the upper bound specified in the flag OPENFGA_LIST_USERS_MAX_RESULTS, whichever is hit first. The returned users will not be sorted, and therefore two identical calls may yield different sets of users.
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ListUsersResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(
            String storeId, ListUsersRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return listUsers(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(
            String storeId, ListUsersRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "listUsers");

        assertParamExists(body, "body", "listUsers");

        String path = "/stores/{store_id}/list-users".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListUsers");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "listUsers", ListUsersResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Get tuples from the store that matches a query, without following userset rewrite rules
     * The Read API will return the tuples for a certain store that match a query filter specified in the body of the request.  The API doesn&#39;t guarantee order by any field.  It is different from the &#x60;/stores/{store_id}/expand&#x60; API in that it only returns relationship tuples that are stored in the system and satisfy the query.  In the body: 1. &#x60;tuple_key&#x60; is optional. If not specified, it will return all tuples in the store. 2. &#x60;tuple_key.object&#x60; is mandatory if &#x60;tuple_key&#x60; is specified. It can be a full object (e.g., &#x60;type:object_id&#x60;) or type only (e.g., &#x60;type:&#x60;). 3. &#x60;tuple_key.user&#x60; is mandatory if tuple_key is specified in the case the &#x60;tuple_key.object&#x60; is a type only. ## Examples ### Query for all objects in a type definition To query for all objects that &#x60;user:bob&#x60; has &#x60;reader&#x60; relationship in the &#x60;document&#x60; type definition, call read API with body of &#x60;&#x60;&#x60;json {  \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;user:bob\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:\&quot;   } } &#x60;&#x60;&#x60; The API will return tuples and a continuation token, something like &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;user:bob&#x60; has a &#x60;reader&#x60; relationship with 1 document &#x60;document:2021-budget&#x60;. Note that this API, unlike the List Objects API, does not evaluate the tuples in the store. The continuation token will be empty if there are no more tuples to query. ### Query for all stored relationship tuples that have a particular relation and object To query for all users that have &#x60;reader&#x60; relationship with &#x60;document:2021-budget&#x60;, call read API with body of  &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;    } } &#x60;&#x60;&#x60; The API will return something like  &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;document:2021-budget&#x60; has 1 &#x60;reader&#x60; (&#x60;user:bob&#x60;).  Note that, even if the model said that all &#x60;writers&#x60; are also &#x60;readers&#x60;, the API will not return writers such as &#x60;user:anne&#x60; because it only returns tuples and does not evaluate them. ### Query for all users with all relationships for a particular document To query for all users that have any relationship with &#x60;document:2021-budget&#x60;, call read API with body of  &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {       \&quot;object\&quot;: \&quot;document:2021-budget\&quot;    } } &#x60;&#x60;&#x60; The API will return something like  &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;writer\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-05T13:42:12.356Z\&quot;     },     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;document:2021-budget&#x60; has 1 &#x60;reader&#x60; (&#x60;user:bob&#x60;) and 1 &#x60;writer&#x60; (&#x60;user:anne&#x60;).
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ReadResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadResponse>> read(String storeId, ReadRequest body)
            throws ApiException, FgaInvalidParameterException {
        return read(storeId, body, this.configuration);
    }

    /**
     * Get tuples from the store that matches a query, without following userset rewrite rules
     * The Read API will return the tuples for a certain store that match a query filter specified in the body of the request.  The API doesn&#39;t guarantee order by any field.  It is different from the &#x60;/stores/{store_id}/expand&#x60; API in that it only returns relationship tuples that are stored in the system and satisfy the query.  In the body: 1. &#x60;tuple_key&#x60; is optional. If not specified, it will return all tuples in the store. 2. &#x60;tuple_key.object&#x60; is mandatory if &#x60;tuple_key&#x60; is specified. It can be a full object (e.g., &#x60;type:object_id&#x60;) or type only (e.g., &#x60;type:&#x60;). 3. &#x60;tuple_key.user&#x60; is mandatory if tuple_key is specified in the case the &#x60;tuple_key.object&#x60; is a type only. ## Examples ### Query for all objects in a type definition To query for all objects that &#x60;user:bob&#x60; has &#x60;reader&#x60; relationship in the &#x60;document&#x60; type definition, call read API with body of &#x60;&#x60;&#x60;json {  \&quot;tuple_key\&quot;: {      \&quot;user\&quot;: \&quot;user:bob\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;,      \&quot;object\&quot;: \&quot;document:\&quot;   } } &#x60;&#x60;&#x60; The API will return tuples and a continuation token, something like &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;user:bob&#x60; has a &#x60;reader&#x60; relationship with 1 document &#x60;document:2021-budget&#x60;. Note that this API, unlike the List Objects API, does not evaluate the tuples in the store. The continuation token will be empty if there are no more tuples to query. ### Query for all stored relationship tuples that have a particular relation and object To query for all users that have &#x60;reader&#x60; relationship with &#x60;document:2021-budget&#x60;, call read API with body of  &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {      \&quot;object\&quot;: \&quot;document:2021-budget\&quot;,      \&quot;relation\&quot;: \&quot;reader\&quot;    } } &#x60;&#x60;&#x60; The API will return something like  &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;document:2021-budget&#x60; has 1 &#x60;reader&#x60; (&#x60;user:bob&#x60;).  Note that, even if the model said that all &#x60;writers&#x60; are also &#x60;readers&#x60;, the API will not return writers such as &#x60;user:anne&#x60; because it only returns tuples and does not evaluate them. ### Query for all users with all relationships for a particular document To query for all users that have any relationship with &#x60;document:2021-budget&#x60;, call read API with body of  &#x60;&#x60;&#x60;json {   \&quot;tuple_key\&quot;: {       \&quot;object\&quot;: \&quot;document:2021-budget\&quot;    } } &#x60;&#x60;&#x60; The API will return something like  &#x60;&#x60;&#x60;json {   \&quot;tuples\&quot;: [     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;writer\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-05T13:42:12.356Z\&quot;     },     {       \&quot;key\&quot;: {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       },       \&quot;timestamp\&quot;: \&quot;2021-10-06T15:32:11.128Z\&quot;     }   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; This means that &#x60;document:2021-budget&#x60; has 1 &#x60;reader&#x60; (&#x60;user:bob&#x60;) and 1 &#x60;writer&#x60; (&#x60;user:anne&#x60;).
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ReadResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadResponse>> read(
            String storeId, ReadRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return read(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadResponse>> read(
            String storeId, ReadRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "read");

        assertParamExists(body, "body", "read");

        String path = "/stores/{store_id}/read".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Read");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "read", ReadResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Read assertions for an authorization model ID
     * The ReadAssertions API will return, for a given authorization model id, all the assertions stored for it. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
     * @param storeId  (required)
     * @param authorizationModelId  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAssertionsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(
            String storeId, String authorizationModelId) throws ApiException, FgaInvalidParameterException {
        return readAssertions(storeId, authorizationModelId, this.configuration);
    }

    /**
     * Read assertions for an authorization model ID
     * The ReadAssertions API will return, for a given authorization model id, all the assertions stored for it. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
     * @param storeId  (required)
     * @param authorizationModelId  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAssertionsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(
            String storeId, String authorizationModelId, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return readAssertions(storeId, authorizationModelId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(
            String storeId, String authorizationModelId, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "readAssertions");

        assertParamExists(authorizationModelId, "authorizationModelId", "readAssertions");

        String path = "/stores/{store_id}/assertions/{authorization_model_id}"
                .replace("{store_id}", ApiClient.urlEncode(storeId.toString()))
                .replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("authorizationModelId", authorizationModelId);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAssertions");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(
                            request, "readAssertions", ReadAssertionsResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Return a particular version of an authorization model
     * The ReadAuthorizationModel API returns an authorization model by its identifier. The response will return the authorization model for the particular version.  ## Example To retrieve the authorization model with ID &#x60;01G5JAVJ41T49E9TT3SKVS7X1J&#x60; for the store, call the GET authorization-models by ID API with &#x60;01G5JAVJ41T49E9TT3SKVS7X1J&#x60; as the &#x60;id&#x60; path parameter.  The API will return: &#x60;&#x60;&#x60;json {   \&quot;authorization_model\&quot;:{     \&quot;id\&quot;:\&quot;01G5JAVJ41T49E9TT3SKVS7X1J\&quot;,     \&quot;type_definitions\&quot;:[       {         \&quot;type\&quot;:\&quot;user\&quot;       },       {         \&quot;type\&quot;:\&quot;document\&quot;,         \&quot;relations\&quot;:{           \&quot;reader\&quot;:{             \&quot;union\&quot;:{               \&quot;child\&quot;:[                 {                   \&quot;this\&quot;:{}                 },                 {                   \&quot;computedUserset\&quot;:{                     \&quot;object\&quot;:\&quot;\&quot;,                     \&quot;relation\&quot;:\&quot;writer\&quot;                   }                 }               ]             }           },           \&quot;writer\&quot;:{             \&quot;this\&quot;:{}           }         }       }     ]   } } &#x60;&#x60;&#x60; In the above example, there are 2 types (&#x60;user&#x60; and &#x60;document&#x60;). The &#x60;document&#x60; type has 2 relations (&#x60;writer&#x60; and &#x60;reader&#x60;).
     * @param storeId  (required)
     * @param id  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAuthorizationModelResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(
            String storeId, String id) throws ApiException, FgaInvalidParameterException {
        return readAuthorizationModel(storeId, id, this.configuration);
    }

    /**
     * Return a particular version of an authorization model
     * The ReadAuthorizationModel API returns an authorization model by its identifier. The response will return the authorization model for the particular version.  ## Example To retrieve the authorization model with ID &#x60;01G5JAVJ41T49E9TT3SKVS7X1J&#x60; for the store, call the GET authorization-models by ID API with &#x60;01G5JAVJ41T49E9TT3SKVS7X1J&#x60; as the &#x60;id&#x60; path parameter.  The API will return: &#x60;&#x60;&#x60;json {   \&quot;authorization_model\&quot;:{     \&quot;id\&quot;:\&quot;01G5JAVJ41T49E9TT3SKVS7X1J\&quot;,     \&quot;type_definitions\&quot;:[       {         \&quot;type\&quot;:\&quot;user\&quot;       },       {         \&quot;type\&quot;:\&quot;document\&quot;,         \&quot;relations\&quot;:{           \&quot;reader\&quot;:{             \&quot;union\&quot;:{               \&quot;child\&quot;:[                 {                   \&quot;this\&quot;:{}                 },                 {                   \&quot;computedUserset\&quot;:{                     \&quot;object\&quot;:\&quot;\&quot;,                     \&quot;relation\&quot;:\&quot;writer\&quot;                   }                 }               ]             }           },           \&quot;writer\&quot;:{             \&quot;this\&quot;:{}           }         }       }     ]   } } &#x60;&#x60;&#x60; In the above example, there are 2 types (&#x60;user&#x60; and &#x60;document&#x60;). The &#x60;document&#x60; type has 2 relations (&#x60;writer&#x60; and &#x60;reader&#x60;).
     * @param storeId  (required)
     * @param id  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAuthorizationModelResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(
            String storeId, String id, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return readAuthorizationModel(storeId, id, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(
            String storeId, String id, Configuration configuration) throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "readAuthorizationModel");

        assertParamExists(id, "id", "readAuthorizationModel");

        String path = "/stores/{store_id}/authorization-models/{id}"
                .replace("{store_id}", ApiClient.urlEncode(storeId.toString()))
                .replace("{id}", ApiClient.urlEncode(id.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("id", id);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAuthorizationModel");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(
                            request,
                            "readAuthorizationModel",
                            ReadAuthorizationModelResponse.class,
                            apiClient,
                            configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Return all the authorization models for a particular store
     * The ReadAuthorizationModels API will return all the authorization models for a certain store. OpenFGA&#39;s response will contain an array of all authorization models, sorted in descending order of creation.  ## Example Assume that a store&#39;s authorization model has been configured twice. To get all the authorization models that have been created in this store, call GET authorization-models. The API will return a response that looks like: &#x60;&#x60;&#x60;json {   \&quot;authorization_models\&quot;: [     {       \&quot;id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;,       \&quot;type_definitions\&quot;: [...]     },     {       \&quot;id\&quot;: \&quot;01G4ZW8F4A07AKQ8RHSVG9RW04\&quot;,       \&quot;type_definitions\&quot;: [...]     },   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; If there are no more authorization models available, the &#x60;continuation_token&#x60; field will be empty &#x60;&#x60;&#x60;json {   \&quot;authorization_models\&quot;: [     {       \&quot;id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;,       \&quot;type_definitions\&quot;: [...]     },     {       \&quot;id\&quot;: \&quot;01G4ZW8F4A07AKQ8RHSVG9RW04\&quot;,       \&quot;type_definitions\&quot;: [...]     },   ],   \&quot;continuation_token\&quot;: \&quot;\&quot; } &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAuthorizationModelsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(
            String storeId, Integer pageSize, String continuationToken)
            throws ApiException, FgaInvalidParameterException {
        return readAuthorizationModels(storeId, pageSize, continuationToken, this.configuration);
    }

    /**
     * Return all the authorization models for a particular store
     * The ReadAuthorizationModels API will return all the authorization models for a certain store. OpenFGA&#39;s response will contain an array of all authorization models, sorted in descending order of creation.  ## Example Assume that a store&#39;s authorization model has been configured twice. To get all the authorization models that have been created in this store, call GET authorization-models. The API will return a response that looks like: &#x60;&#x60;&#x60;json {   \&quot;authorization_models\&quot;: [     {       \&quot;id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;,       \&quot;type_definitions\&quot;: [...]     },     {       \&quot;id\&quot;: \&quot;01G4ZW8F4A07AKQ8RHSVG9RW04\&quot;,       \&quot;type_definitions\&quot;: [...]     },   ],   \&quot;continuation_token\&quot;: \&quot;eyJwayI6IkxBVEVTVF9OU0NPTkZJR19hdXRoMHN0b3JlIiwic2siOiIxem1qbXF3MWZLZExTcUoyN01MdTdqTjh0cWgifQ&#x3D;&#x3D;\&quot; } &#x60;&#x60;&#x60; If there are no more authorization models available, the &#x60;continuation_token&#x60; field will be empty &#x60;&#x60;&#x60;json {   \&quot;authorization_models\&quot;: [     {       \&quot;id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;,       \&quot;type_definitions\&quot;: [...]     },     {       \&quot;id\&quot;: \&quot;01G4ZW8F4A07AKQ8RHSVG9RW04\&quot;,       \&quot;type_definitions\&quot;: [...]     },   ],   \&quot;continuation_token\&quot;: \&quot;\&quot; } &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ReadAuthorizationModelsResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(
            String storeId, Integer pageSize, String continuationToken, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return readAuthorizationModels(
                storeId, pageSize, continuationToken, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(
            String storeId, Integer pageSize, String continuationToken, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "readAuthorizationModels");

        String path = "/stores/{store_id}/authorization-models"
                .replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        path = pathWithParams(path, "page_size", pageSize, "continuation_token", continuationToken);

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAuthorizationModels");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(
                            request,
                            "readAuthorizationModels",
                            ReadAuthorizationModelsResponse.class,
                            apiClient,
                            configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Return a list of all the tuple changes
     * The ReadChanges API will return a paginated list of tuple changes (additions and deletions) that occurred in a given store, sorted by ascending time. The response will include a continuation token that is used to get the next set of changes. If there are no changes after the provided continuation token, the same token will be returned in order for it to be used when new changes are recorded. If the store never had any tuples added or removed, this token will be empty. You can use the &#x60;type&#x60; parameter to only get the list of tuple changes that affect objects of that type. When reading a write tuple change, if it was conditioned, the condition will be returned. When reading a delete tuple change, the condition will NOT be returned regardless of whether it was originally conditioned or not.
     * @param storeId  (required)
     * @param type  (optional)
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @return CompletableFuture&lt;ApiResponse&lt;ReadChangesResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(
            String storeId, String type, Integer pageSize, String continuationToken)
            throws ApiException, FgaInvalidParameterException {
        return readChanges(storeId, type, pageSize, continuationToken, this.configuration);
    }

    /**
     * Return a list of all the tuple changes
     * The ReadChanges API will return a paginated list of tuple changes (additions and deletions) that occurred in a given store, sorted by ascending time. The response will include a continuation token that is used to get the next set of changes. If there are no changes after the provided continuation token, the same token will be returned in order for it to be used when new changes are recorded. If the store never had any tuples added or removed, this token will be empty. You can use the &#x60;type&#x60; parameter to only get the list of tuple changes that affect objects of that type. When reading a write tuple change, if it was conditioned, the condition will be returned. When reading a delete tuple change, the condition will NOT be returned regardless of whether it was originally conditioned or not.
     * @param storeId  (required)
     * @param type  (optional)
     * @param pageSize  (optional)
     * @param continuationToken  (optional)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;ReadChangesResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(
            String storeId,
            String type,
            Integer pageSize,
            String continuationToken,
            ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return readChanges(
                storeId, type, pageSize, continuationToken, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(
            String storeId, String type, Integer pageSize, String continuationToken, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "readChanges");

        String path = "/stores/{store_id}/changes".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        path = pathWithParams(path, "type", type, "page_size", pageSize, "continuation_token", continuationToken);

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadChanges");

        try {
            HttpRequest request = buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<>(request, "readChanges", ReadChangesResponse.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Add or delete tuples from the store
     * The Write API will transactionally update the tuples for a certain store. Tuples and type definitions allow OpenFGA to determine whether a relationship exists between an object and an user. In the body, &#x60;writes&#x60; adds new tuples and &#x60;deletes&#x60; removes existing tuples. When deleting a tuple, any &#x60;condition&#x60; specified with it is ignored. The API is not idempotent: if, later on, you try to add the same tuple key (even if the &#x60;condition&#x60; is different), or if you try to delete a non-existing tuple, it will throw an error. The API will not allow you to write tuples such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;, because they are implicit. An &#x60;authorization_model_id&#x60; may be specified in the body. If it is, it will be used to assert that each written tuple (not deleted) is valid for the model specified. If it is not specified, the latest authorization model ID will be used. ## Example ### Adding relationships To add &#x60;user:anne&#x60; as a &#x60;writer&#x60; for &#x60;document:2021-budget&#x60;, call write API with the following  &#x60;&#x60;&#x60;json {   \&quot;writes\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;writer\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; ### Removing relationships To remove &#x60;user:bob&#x60; as a &#x60;reader&#x60; for &#x60;document:2021-budget&#x60;, call write API with the following  &#x60;&#x60;&#x60;json {   \&quot;deletes\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   } } &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;Object&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Object>> write(String storeId, WriteRequest body)
            throws ApiException, FgaInvalidParameterException {
        return write(storeId, body, this.configuration);
    }

    /**
     * Add or delete tuples from the store
     * The Write API will transactionally update the tuples for a certain store. Tuples and type definitions allow OpenFGA to determine whether a relationship exists between an object and an user. In the body, &#x60;writes&#x60; adds new tuples and &#x60;deletes&#x60; removes existing tuples. When deleting a tuple, any &#x60;condition&#x60; specified with it is ignored. The API is not idempotent: if, later on, you try to add the same tuple key (even if the &#x60;condition&#x60; is different), or if you try to delete a non-existing tuple, it will throw an error. The API will not allow you to write tuples such as &#x60;document:2021-budget#viewer@document:2021-budget#viewer&#x60;, because they are implicit. An &#x60;authorization_model_id&#x60; may be specified in the body. If it is, it will be used to assert that each written tuple (not deleted) is valid for the model specified. If it is not specified, the latest authorization model ID will be used. ## Example ### Adding relationships To add &#x60;user:anne&#x60; as a &#x60;writer&#x60; for &#x60;document:2021-budget&#x60;, call write API with the following  &#x60;&#x60;&#x60;json {   \&quot;writes\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:anne\&quot;,         \&quot;relation\&quot;: \&quot;writer\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   },   \&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot; } &#x60;&#x60;&#x60; ### Removing relationships To remove &#x60;user:bob&#x60; as a &#x60;reader&#x60; for &#x60;document:2021-budget&#x60;, call write API with the following  &#x60;&#x60;&#x60;json {   \&quot;deletes\&quot;: {     \&quot;tuple_keys\&quot;: [       {         \&quot;user\&quot;: \&quot;user:bob\&quot;,         \&quot;relation\&quot;: \&quot;reader\&quot;,         \&quot;object\&quot;: \&quot;document:2021-budget\&quot;       }     ]   } } &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;Object&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Object>> write(
            String storeId, WriteRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return write(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Object>> write(String storeId, WriteRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "write");

        assertParamExists(body, "body", "write");

        String path = "/stores/{store_id}/write".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Write");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(request, "write", Object.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Upsert assertions for an authorization model ID
     * The WriteAssertions API will upsert new assertions for an authorization model id, or overwrite the existing ones. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
     * @param storeId  (required)
     * @param authorizationModelId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;Void&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Void>> writeAssertions(
            String storeId, String authorizationModelId, WriteAssertionsRequest body)
            throws ApiException, FgaInvalidParameterException {
        return writeAssertions(storeId, authorizationModelId, body, this.configuration);
    }

    /**
     * Upsert assertions for an authorization model ID
     * The WriteAssertions API will upsert new assertions for an authorization model id, or overwrite the existing ones. An assertion is an object that contains a tuple key, and the expectation of whether a call to the Check API of that tuple key will return true or false.
     * @param storeId  (required)
     * @param authorizationModelId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;Void&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<Void>> writeAssertions(
            String storeId,
            String authorizationModelId,
            WriteAssertionsRequest body,
            ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return writeAssertions(storeId, authorizationModelId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Void>> writeAssertions(
            String storeId, String authorizationModelId, WriteAssertionsRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "writeAssertions");

        assertParamExists(authorizationModelId, "authorizationModelId", "writeAssertions");

        assertParamExists(body, "body", "writeAssertions");

        String path = "/stores/{store_id}/assertions/{authorization_model_id}"
                .replace("{store_id}", ApiClient.urlEncode(storeId.toString()))
                .replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("authorizationModelId", authorizationModelId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "WriteAssertions");

        try {
            HttpRequest request = buildHttpRequest("PUT", path, body, configuration);
            return new HttpRequestAttempt<>(request, "writeAssertions", Void.class, apiClient, configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    /**
     * Create a new authorization model
     * The WriteAuthorizationModel API will add a new authorization model to a store. Each item in the &#x60;type_definitions&#x60; array is a type definition as specified in the field &#x60;type_definition&#x60;. The response will return the authorization model&#39;s ID in the &#x60;id&#x60; field.  ## Example To add an authorization model with &#x60;user&#x60; and &#x60;document&#x60; type definitions, call POST authorization-models API with the body:  &#x60;&#x60;&#x60;json {   \&quot;type_definitions\&quot;:[     {       \&quot;type\&quot;:\&quot;user\&quot;     },     {       \&quot;type\&quot;:\&quot;document\&quot;,       \&quot;relations\&quot;:{         \&quot;reader\&quot;:{           \&quot;union\&quot;:{             \&quot;child\&quot;:[               {                 \&quot;this\&quot;:{}               },               {                 \&quot;computedUserset\&quot;:{                   \&quot;object\&quot;:\&quot;\&quot;,                   \&quot;relation\&quot;:\&quot;writer\&quot;                 }               }             ]           }         },         \&quot;writer\&quot;:{           \&quot;this\&quot;:{}         }       }     }   ] } &#x60;&#x60;&#x60; OpenFGA&#39;s response will include the version id for this authorization model, which will look like  &#x60;&#x60;&#x60; {\&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;} &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param body  (required)
     * @return CompletableFuture&lt;ApiResponse&lt;WriteAuthorizationModelResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(
            String storeId, WriteAuthorizationModelRequest body) throws ApiException, FgaInvalidParameterException {
        return writeAuthorizationModel(storeId, body, this.configuration);
    }

    /**
     * Create a new authorization model
     * The WriteAuthorizationModel API will add a new authorization model to a store. Each item in the &#x60;type_definitions&#x60; array is a type definition as specified in the field &#x60;type_definition&#x60;. The response will return the authorization model&#39;s ID in the &#x60;id&#x60; field.  ## Example To add an authorization model with &#x60;user&#x60; and &#x60;document&#x60; type definitions, call POST authorization-models API with the body:  &#x60;&#x60;&#x60;json {   \&quot;type_definitions\&quot;:[     {       \&quot;type\&quot;:\&quot;user\&quot;     },     {       \&quot;type\&quot;:\&quot;document\&quot;,       \&quot;relations\&quot;:{         \&quot;reader\&quot;:{           \&quot;union\&quot;:{             \&quot;child\&quot;:[               {                 \&quot;this\&quot;:{}               },               {                 \&quot;computedUserset\&quot;:{                   \&quot;object\&quot;:\&quot;\&quot;,                   \&quot;relation\&quot;:\&quot;writer\&quot;                 }               }             ]           }         },         \&quot;writer\&quot;:{           \&quot;this\&quot;:{}         }       }     }   ] } &#x60;&#x60;&#x60; OpenFGA&#39;s response will include the version id for this authorization model, which will look like  &#x60;&#x60;&#x60; {\&quot;authorization_model_id\&quot;: \&quot;01G50QVV17PECNVAHX1GG4Y5NC\&quot;} &#x60;&#x60;&#x60;
     * @param storeId  (required)
     * @param body  (required)
     * @param configurationOverride Override the {@link Configuration} this OpenFgaApi was constructed with
     * @return CompletableFuture&lt;ApiResponse&lt;WriteAuthorizationModelResponse&gt;&gt;
     * @throws ApiException if fails to make API call
     */
    public CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(
            String storeId, WriteAuthorizationModelRequest body, ConfigurationOverride configurationOverride)
            throws ApiException, FgaInvalidParameterException {
        return writeAuthorizationModel(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(
            String storeId, WriteAuthorizationModelRequest body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {

        assertParamExists(storeId, "storeId", "writeAuthorizationModel");

        assertParamExists(body, "body", "writeAuthorizationModel");

        String path = "/stores/{store_id}/authorization-models"
                .replace("{store_id}", ApiClient.urlEncode(storeId.toString()));

        Map<String, Object> methodParameters = new HashMap<>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);

        Map<Attribute, String> telemetryAttributes = buildTelemetryAttributes(methodParameters);

        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "WriteAuthorizationModel");

        try {
            HttpRequest request = buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<>(
                            request,
                            "writeAuthorizationModel",
                            WriteAuthorizationModelResponse.class,
                            apiClient,
                            configuration)
                    .addTelemetryAttributes(telemetryAttributes)
                    .attemptHttpRequest();
        } catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Map<Attribute, String> buildTelemetryAttributes(Map<String, Object> attributes) {
        Map<Attribute, String> telemetryAttributes = new HashMap<>();

        Object storeId = attributes.get("storeId");
        Object authorizationModelId = attributes.get("authorizationModelId");
        Object body = attributes.get("body");

        if (storeId != null) {
            telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_STORE_ID, storeId.toString());
        }

        if (authorizationModelId != null) {
            telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, authorizationModelId.toString());
        }

        if (body != null) {
            if (body instanceof CheckRequest) {
                CheckRequest checkRequest = (CheckRequest) body;

                if (checkRequest.getTupleKey() != null
                        && !isNullOrWhitespace(checkRequest.getTupleKey().getUser())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_USER,
                            checkRequest.getTupleKey().getUser());
                }

                if (!isNullOrWhitespace(checkRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_REQUEST_MODEL_ID, checkRequest.getAuthorizationModelId());
                }
            }

            if (body instanceof ExpandRequest) {
                ExpandRequest expandRequest = (ExpandRequest) body;

                if (!isNullOrWhitespace(expandRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_REQUEST_MODEL_ID, expandRequest.getAuthorizationModelId());
                }
            }

            if (body instanceof ListObjectsRequest) {
                ListObjectsRequest listObjectsRequest = (ListObjectsRequest) body;

                if (!isNullOrWhitespace(listObjectsRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_REQUEST_MODEL_ID, listObjectsRequest.getAuthorizationModelId());
                }
            }

            if (body instanceof ListUsersRequest) {
                ListUsersRequest listUsersRequest = (ListUsersRequest) body;

                if (!isNullOrWhitespace(listUsersRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_REQUEST_MODEL_ID, listUsersRequest.getAuthorizationModelId());
                }
            }

            if (body instanceof WriteRequest) {
                WriteRequest writeRequest = (WriteRequest) body;

                if (!isNullOrWhitespace(writeRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(
                            Attributes.FGA_CLIENT_REQUEST_MODEL_ID, writeRequest.getAuthorizationModelId());
                }
            }
        }

        return telemetryAttributes;
    }

    private HttpRequest buildHttpRequest(String method, String path, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {
        return buildHttpRequestWithPublisher(method, path, HttpRequest.BodyPublishers.noBody(), configuration);
    }

    private <T> HttpRequest buildHttpRequest(String method, String path, T body, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {
        try {
            byte[] localVarPostBody = apiClient.getObjectMapper().writeValueAsBytes(body);
            var bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(localVarPostBody);
            return buildHttpRequestWithPublisher(method, path, bodyPublisher, configuration);
        } catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private HttpRequest buildHttpRequestWithPublisher(
            String method, String path, HttpRequest.BodyPublisher bodyPublisher, Configuration configuration)
            throws ApiException, FgaInvalidParameterException {
        // verify the Configuration is valid
        configuration.assertValid();

        var httpRequest = HttpRequest.newBuilder();

        httpRequest.uri(URI.create(configuration.getApiUrl() + path));

        httpRequest.header("Content-Type", "application/json");
        httpRequest.header("Accept", "application/json");

        if (configuration.getCredentials().getCredentialsMethod() != CredentialsMethod.NONE) {
            String accessToken = getAccessToken(configuration);
            httpRequest.header("Authorization", "Bearer " + accessToken);
        }

        if (configuration.getUserAgent() != null) {
            httpRequest.header("User-Agent", configuration.getUserAgent());
        }

        if (configuration.getDefaultHeaders() != null) {
            configuration.getDefaultHeaders().forEach(httpRequest::header);
        }

        httpRequest.method(method, bodyPublisher);

        Duration readTimeout = configuration.getReadTimeout();
        if (readTimeout != null) {
            httpRequest.timeout(readTimeout);
        }
        if (apiClient.getRequestInterceptor() != null) {
            apiClient.getRequestInterceptor().accept(httpRequest);
        }

        return httpRequest.build();
    }

    private String pathWithParams(String basePath, Object... params) {
        var path = new StringBuilder().append(basePath);
        var paramStream = Stream.<String>builder();
        for (int i = 0; i < params.length - 1; i += 2) {
            if (params[i] == null || params[i + 1] == null) {
                continue;
            }
            Pair.of(params[i].toString(), params[i + 1].toString())
                    .map(Pair::asQueryStringPair)
                    .ifPresent(paramStream::add);
        }
        String parameters = paramStream.build().collect(Collectors.joining("&"));
        if (!isNullOrWhitespace(parameters)) {
            path.append("?").append(parameters);
        }
        return path.toString();
    }

    /**
     * Get an access token. Expects that configuration is valid (meaning it can
     * pass {@link Configuration#assertValid()}) and expects that if the
     * CredentialsMethod is CLIENT_CREDENTIALS that a valid {@link OAuth2Client}
     * has been initialized. Otherwise, it will throw an IllegalStateException.
     * @throws IllegalStateException when the configuration is invalid
     */
    private String getAccessToken(Configuration configuration) throws ApiException {
        CredentialsMethod credentialsMethod = configuration.getCredentials().getCredentialsMethod();

        if (credentialsMethod == CredentialsMethod.API_TOKEN) {
            return configuration.getCredentials().getApiToken().getToken();
        }

        if (credentialsMethod == CredentialsMethod.CLIENT_CREDENTIALS) {
            try {
                return oAuth2Client.getAccessToken().get();
            } catch (Exception e) {
                throw new ApiException(e);
            }
        }

        throw new IllegalStateException("Configuration is invalid.");
    }
}
