/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.client.model;

import dev.openfga.sdk.api.model.CheckResponse;
import dev.openfga.sdk.errors.FgaError;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class ClientBatchCheckResponse extends CheckResponse {
    private final ClientCheckRequest request;
    private final Throwable throwable;
    private final Integer statusCode;
    private final Map<String, List<String>> headers;
    private final String rawResponse;

    public ClientBatchCheckResponse(
            ClientCheckRequest request, ClientCheckResponse clientCheckResponse, Throwable throwable) {
        this.request = request;
        this.throwable = throwable;

        if (clientCheckResponse != null) {
            this.statusCode = clientCheckResponse.getStatusCode();
            this.headers = clientCheckResponse.getHeaders();
            this.rawResponse = clientCheckResponse.getRawResponse();
            this.setAllowed(clientCheckResponse.getAllowed());
            this.setResolution(clientCheckResponse.getResolution());
        } else if (throwable instanceof FgaError) {
            FgaError error = (FgaError) throwable;
            this.statusCode = error.getStatusCode();
            this.headers = error.getResponseHeaders().map();
            this.rawResponse = error.getResponseData();
        } else {
            // Should be unreachable, but required for type completion
            this.statusCode = null;
            this.headers = null;
            this.rawResponse = null;
        }
    }

    public ClientCheckRequest getRequest() {
        return request;
    }

    /**
     * Returns the result of the check.
     * <p>
     * If the HTTP request was unsuccessful, this result will be null. If this is the case, you can examine the
     * original request with {@link ClientBatchCheckResponse#getRequest()} and the exception with
     * {@link ClientBatchCheckResponse#getThrowable()}.
     *
     * @return the check result. Is null if the HTTP request was unsuccessful.
     */
    @Override
    public Boolean getAllowed() {
        return super.getAllowed();
    }

    /**
     * Returns the caught exception if the HTTP request was unsuccessful.
     * <p>
     * If the HTTP request was unsuccessful, this result will be null. If this is the case, you can examine the
     * original request with {@link ClientBatchCheckResponse#getRequest()} and the exception with
     * {@link ClientBatchCheckResponse#getThrowable()}.
     *
     * @return the caught exception. Is null if the HTTP request was successful.
     */
    public Throwable getThrowable() {
        return throwable;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return headers;
    }

    public String getRawResponse() {
        return rawResponse;
    }

    public String getRelation() {
        return request == null ? null : request.getRelation();
    }

    public static BiFunction<ClientCheckResponse, Throwable, ClientBatchCheckResponse> asyncHandler(
            ClientCheckRequest request) {
        return (response, throwable) -> new ClientBatchCheckResponse(request, response, throwable);
    }
}
