/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * Assertion
 */
@JsonPropertyOrder({Assertion.JSON_PROPERTY_TUPLE_KEY, Assertion.JSON_PROPERTY_EXPECTATION})
public class Assertion {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    private AssertionTupleKey tupleKey;

    public static final String JSON_PROPERTY_EXPECTATION = "expectation";
    private Boolean expectation;

    public Assertion() {}

    public Assertion tupleKey(AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    /**
     * Get tupleKey
     * @return tupleKey
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_TUPLE_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public AssertionTupleKey getTupleKey() {
        return tupleKey;
    }

    @JsonProperty(JSON_PROPERTY_TUPLE_KEY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setTupleKey(AssertionTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public Assertion expectation(Boolean expectation) {
        this.expectation = expectation;
        return this;
    }

    /**
     * Get expectation
     * @return expectation
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_EXPECTATION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public Boolean getExpectation() {
        return expectation;
    }

    @JsonProperty(JSON_PROPERTY_EXPECTATION)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setExpectation(Boolean expectation) {
        this.expectation = expectation;
    }

    /**
     * Return true if this Assertion object is equal to o.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Assertion assertion = (Assertion) o;
        return Objects.equals(this.tupleKey, assertion.tupleKey)
                && Objects.equals(this.expectation, assertion.expectation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tupleKey, expectation);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Assertion {\n");
        sb.append("    tupleKey: ").append(toIndentedString(tupleKey)).append("\n");
        sb.append("    expectation: ").append(toIndentedString(expectation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    /**
     * Convert the instance into URL query string.
     *
     * @return URL query string
     */
    public String toUrlQueryString() {
        return toUrlQueryString(null);
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix prefix of the query string
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            // style=form, explode=true, e.g. /pet?name=cat&type=manx
            prefix = "";
        } else {
            // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }

        StringJoiner joiner = new StringJoiner("&");

        // add `tuple_key` to the URL query string
        if (getTupleKey() != null) {
            joiner.add(getTupleKey().toUrlQueryString(prefix + "tuple_key" + suffix));
        }

        // add `expectation` to the URL query string
        if (getExpectation() != null) {
            joiner.add(String.format(
                    "%sexpectation%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getExpectation()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        return joiner.toString();
    }
}
