/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.auth;

import dev.openfga.sdk.api.auth.AccessToken;
import dev.openfga.sdk.api.auth.CredentialsFlowRequest;
import dev.openfga.sdk.api.auth.CredentialsFlowResponse;
import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.ApiResponse;
import dev.openfga.sdk.api.client.HttpRequestAttempt;
import dev.openfga.sdk.api.configuration.ClientCredentials;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.errors.ApiException;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Telemetry;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OAuth2Client {
    private static final String DEFAULT_API_TOKEN_ISSUER_PATH = "/oauth/token";
    private final ApiClient apiClient;
    private final AccessToken token = new AccessToken();
    private final CredentialsFlowRequest authRequest;
    private final Configuration config;
    private final Telemetry telemetry;

    public OAuth2Client(Configuration configuration, ApiClient apiClient) throws FgaInvalidParameterException {
        ClientCredentials clientCredentials = configuration.getCredentials().getClientCredentials();
        this.apiClient = apiClient;
        this.authRequest = new CredentialsFlowRequest(clientCredentials.getClientId(), clientCredentials.getClientSecret());
        this.authRequest.setAudience(clientCredentials.getApiAudience());
        this.authRequest.setScope(clientCredentials.getScopes());
        this.config = new Configuration().apiUrl(OAuth2Client.buildApiTokenIssuer(clientCredentials.getApiTokenIssuer())).maxRetries(configuration.getMaxRetries()).minimumRetryDelay(configuration.getMinimumRetryDelay());
        this.telemetry = new Telemetry(this.config);
    }

    public CompletableFuture<String> getAccessToken() throws FgaInvalidParameterException, ApiException {
        if (!this.token.isValid()) {
            return this.exchangeToken().thenCompose(response -> {
                this.token.setToken(response.getAccessToken());
                this.token.setExpiresAt(Instant.now().plusSeconds(response.getExpiresInSeconds()));
                HashMap<Attribute, String> attributesMap = new HashMap<Attribute, String>();
                this.telemetry.metrics().credentialsRequest(1L, attributesMap);
                return CompletableFuture.completedFuture(this.token.getToken());
            });
        }
        return CompletableFuture.completedFuture(this.token.getToken());
    }

    private CompletableFuture<CredentialsFlowResponse> exchangeToken() throws ApiException, FgaInvalidParameterException {
        HttpRequest.Builder requestBuilder = ApiClient.formRequestBuilder("POST", "", this.authRequest.buildFormRequestBody(), this.config);
        HttpRequest request = requestBuilder.build();
        return new HttpRequestAttempt<CredentialsFlowResponse>(request, "exchangeToken", CredentialsFlowResponse.class, this.apiClient, this.config).attemptHttpRequest().thenApply(ApiResponse::getData);
    }

    private static String buildApiTokenIssuer(String issuer) throws FgaInvalidParameterException {
        URI uri;
        try {
            uri = URI.create(issuer);
        }
        catch (IllegalArgumentException cause) {
            throw new FgaInvalidParameterException("apiTokenIssuer", "ClientCredentials", cause);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            uri = URI.create("https://" + issuer);
        } else if (!"https".equals(scheme) && !"http".equals(scheme)) {
            throw new FgaInvalidParameterException("scheme", "apiTokenIssuer");
        }
        if (uri.getPath().isEmpty() || uri.getPath().equals("/")) {
            uri = URI.create(uri.getScheme() + "://" + uri.getAuthority() + DEFAULT_API_TOKEN_ISSUER_PATH);
        }
        return uri.toString();
    }
}

