/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client;

import dev.openfga.sdk.api.model.Assertion;
import dev.openfga.sdk.api.model.AssertionTupleKey;
import java.util.List;
import java.util.stream.Collectors;

public class ClientAssertion {
    private String user;
    private String relation;
    private String _object;
    private boolean expectation;

    public ClientAssertion user(String user) {
        this.user = user;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public ClientAssertion relation(String relation) {
        this.relation = relation;
        return this;
    }

    public String getRelation() {
        return this.relation;
    }

    public ClientAssertion _object(String _object) {
        this._object = _object;
        return this;
    }

    public String getObject() {
        return this._object;
    }

    public ClientAssertion expectation(boolean expectation) {
        this.expectation = expectation;
        return this;
    }

    public boolean getExpectation() {
        return this.expectation;
    }

    public Assertion asAssertion() {
        AssertionTupleKey tupleKey = new AssertionTupleKey().user(this.user).relation(this.relation)._object(this._object);
        return new Assertion().tupleKey(tupleKey).expectation(this.expectation);
    }

    public static List<Assertion> asAssertions(List<ClientAssertion> assertions) {
        if (assertions == null || assertions.isEmpty()) {
            return List.of();
        }
        return assertions.stream().map(ClientAssertion::asAssertion).collect(Collectors.toList());
    }
}

