/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.client.model;

import dev.openfga.sdk.api.client.model.ClientCheckRequest;
import dev.openfga.sdk.api.client.model.ClientCheckResponse;
import dev.openfga.sdk.api.model.CheckResponse;
import dev.openfga.sdk.errors.FgaError;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class ClientBatchCheckResponse
extends CheckResponse {
    private final ClientCheckRequest request;
    private final Throwable throwable;
    private final Integer statusCode;
    private final Map<String, List<String>> headers;
    private final String rawResponse;

    public ClientBatchCheckResponse(ClientCheckRequest request, ClientCheckResponse clientCheckResponse, Throwable throwable) {
        this.request = request;
        this.throwable = throwable;
        if (clientCheckResponse != null) {
            this.statusCode = clientCheckResponse.getStatusCode();
            this.headers = clientCheckResponse.getHeaders();
            this.rawResponse = clientCheckResponse.getRawResponse();
            this.setAllowed(clientCheckResponse.getAllowed());
            this.setResolution(clientCheckResponse.getResolution());
        } else if (throwable instanceof FgaError) {
            FgaError error = (FgaError)throwable;
            this.statusCode = error.getStatusCode();
            this.headers = error.getResponseHeaders().map();
            this.rawResponse = error.getResponseData();
        } else {
            this.statusCode = null;
            this.headers = null;
            this.rawResponse = null;
        }
    }

    public ClientCheckRequest getRequest() {
        return this.request;
    }

    @Override
    public Boolean getAllowed() {
        return super.getAllowed();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public String getRelation() {
        return this.request == null ? null : this.request.getRelation();
    }

    public static BiFunction<ClientCheckResponse, Throwable, ClientBatchCheckResponse> asyncHandler(ClientCheckRequest request) {
        return (response, throwable) -> new ClientBatchCheckResponse(request, (ClientCheckResponse)response, (Throwable)throwable);
    }
}

