/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.configuration;

import dev.openfga.sdk.api.configuration.AdditionalHeadersSupplier;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.util.StringUtil;
import java.util.Map;

public class ClientReadAuthorizationModelOptions
implements AdditionalHeadersSupplier {
    private Map<String, String> additionalHeaders;
    private String authorizationModelId;

    public ClientReadAuthorizationModelOptions additionalHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    @Override
    public Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public void assertValidAuthorizationModelId() throws FgaInvalidParameterException {
        if (StringUtil.isNullOrWhitespace(this.authorizationModelId)) {
            throw new FgaInvalidParameterException("authorizationModelId", "ClientConfiguration");
        }
    }

    public ClientReadAuthorizationModelOptions authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    public String getAuthorizationModelIdChecked() throws FgaInvalidParameterException {
        this.assertValidAuthorizationModelId();
        return this.authorizationModelId;
    }
}

