/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.ConsistencyPreference;
import dev.openfga.sdk.api.model.ContextualTupleKeys;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authorization_model_id", "type", "relation", "user", "contextual_tuples", "context", "consistency"})
public class ListObjectsRequest {
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;
    public static final String JSON_PROPERTY_USER = "user";
    private String user;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    private ContextualTupleKeys contextualTuples;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Object context;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public ListObjectsRequest authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ListObjectsRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public ListObjectsRequest relation(String relation) {
        this.relation = relation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public ListObjectsRequest user(String user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(String user) {
        this.user = user;
    }

    public ListObjectsRequest contextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public ListObjectsRequest context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Object context) {
        this.context = context;
    }

    public ListObjectsRequest consistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListObjectsRequest listObjectsRequest = (ListObjectsRequest)o;
        return Objects.equals(this.authorizationModelId, listObjectsRequest.authorizationModelId) && Objects.equals(this.type, listObjectsRequest.type) && Objects.equals(this.relation, listObjectsRequest.relation) && Objects.equals(this.user, listObjectsRequest.user) && Objects.equals(this.contextualTuples, listObjectsRequest.contextualTuples) && Objects.equals(this.context, listObjectsRequest.context) && Objects.equals((Object)this.consistency, (Object)listObjectsRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationModelId, this.type, this.relation, this.user, this.contextualTuples, this.context, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListObjectsRequest {\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorizationModelId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getType() != null) {
            joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getType()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUser() != null) {
            joiner.add(String.format("%suser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUser()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContext()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConsistency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

