/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.ConsistencyPreference;
import dev.openfga.sdk.api.model.FgaObject;
import dev.openfga.sdk.api.model.TupleKey;
import dev.openfga.sdk.api.model.UserTypeFilter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authorization_model_id", "object", "relation", "user_filters", "contextual_tuples", "context", "consistency"})
public class ListUsersRequest {
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;
    public static final String JSON_PROPERTY_OBJECT = "object";
    private FgaObject _object;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;
    public static final String JSON_PROPERTY_USER_FILTERS = "user_filters";
    private List<UserTypeFilter> userFilters = new ArrayList<UserTypeFilter>();
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    private List<TupleKey> contextualTuples = new ArrayList<TupleKey>();
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Object context;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public ListUsersRequest authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ListUsersRequest _object(FgaObject _object) {
        this._object = _object;
        return this;
    }

    @Nonnull
    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FgaObject getObject() {
        return this._object;
    }

    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObject(FgaObject _object) {
        this._object = _object;
    }

    public ListUsersRequest relation(String relation) {
        this.relation = relation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public ListUsersRequest userFilters(List<UserTypeFilter> userFilters) {
        this.userFilters = userFilters;
        return this;
    }

    public ListUsersRequest addUserFiltersItem(UserTypeFilter userFiltersItem) {
        if (this.userFilters == null) {
            this.userFilters = new ArrayList<UserTypeFilter>();
        }
        this.userFilters.add(userFiltersItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="user_filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<UserTypeFilter> getUserFilters() {
        return this.userFilters;
    }

    @JsonProperty(value="user_filters")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserFilters(List<UserTypeFilter> userFilters) {
        this.userFilters = userFilters;
    }

    public ListUsersRequest contextualTuples(List<TupleKey> contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    public ListUsersRequest addContextualTuplesItem(TupleKey contextualTuplesItem) {
        if (this.contextualTuples == null) {
            this.contextualTuples = new ArrayList<TupleKey>();
        }
        this.contextualTuples.add(contextualTuplesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TupleKey> getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(List<TupleKey> contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public ListUsersRequest context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Object context) {
        this.context = context;
    }

    public ListUsersRequest consistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListUsersRequest listUsersRequest = (ListUsersRequest)o;
        return Objects.equals(this.authorizationModelId, listUsersRequest.authorizationModelId) && Objects.equals(this._object, listUsersRequest._object) && Objects.equals(this.relation, listUsersRequest.relation) && Objects.equals(this.userFilters, listUsersRequest.userFilters) && Objects.equals(this.contextualTuples, listUsersRequest.contextualTuples) && Objects.equals(this.context, listUsersRequest.context) && Objects.equals((Object)this.consistency, (Object)listUsersRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationModelId, this._object, this.relation, this.userFilters, this.contextualTuples, this.context, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListUsersRequest {\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    userFilters: ").append(this.toIndentedString(this.userFilters)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        int i;
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorizationModelId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getObject() != null) {
            joiner.add(this.getObject().toUrlQueryString((String)prefix + JSON_PROPERTY_OBJECT + suffix));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUserFilters() != null) {
            for (i = 0; i < this.getUserFilters().size(); ++i) {
                if (this.getUserFilters().get(i) == null) continue;
                joiner.add(this.getUserFilters().get(i).toUrlQueryString(String.format("%suser_filters%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContextualTuples() != null) {
            for (i = 0; i < this.getContextualTuples().size(); ++i) {
                if (this.getContextualTuples().get(i) == null) continue;
                joiner.add(this.getContextualTuples().get(i).toUrlQueryString(String.format("%scontextual_tuples%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContext()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConsistency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

