/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.ConsistencyPreference;
import dev.openfga.sdk.api.model.ReadRequestTupleKey;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tuple_key", "page_size", "continuation_token", "consistency"})
public class ReadRequest {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    private ReadRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_PAGE_SIZE = "page_size";
    private Integer pageSize;
    public static final String JSON_PROPERTY_CONTINUATION_TOKEN = "continuation_token";
    private String continuationToken;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public ReadRequest tupleKey(ReadRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReadRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTupleKey(ReadRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public ReadRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Nullable
    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPageSize() {
        return this.pageSize;
    }

    @JsonProperty(value="page_size")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ReadRequest continuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    @Nullable
    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContinuationToken() {
        return this.continuationToken;
    }

    @JsonProperty(value="continuation_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
    }

    public ReadRequest consistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadRequest readRequest = (ReadRequest)o;
        return Objects.equals(this.tupleKey, readRequest.tupleKey) && Objects.equals(this.pageSize, readRequest.pageSize) && Objects.equals(this.continuationToken, readRequest.continuationToken) && Objects.equals((Object)this.consistency, (Object)readRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.pageSize, this.continuationToken, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadRequest {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    continuationToken: ").append(this.toIndentedString(this.continuationToken)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getPageSize() != null) {
            joiner.add(String.format("%spage_size%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getPageSize()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContinuationToken() != null) {
            joiner.add(String.format("%scontinuation_token%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContinuationToken()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConsistency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

