/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.errors;

public class HttpStatusCode {
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int UNPROCESSABLE_ENTITY = 422;
    public static final int TOO_MANY_REQUESTS = 429;
    public static final int NOT_IMPLEMENTED = 501;

    private HttpStatusCode() {
    }

    public static boolean isSuccessful(int statusCode) {
        return HttpStatusCode.isBetween(200, statusCode, 300);
    }

    public static boolean isServerError(int statusCode) {
        return HttpStatusCode.isBetween(500, statusCode, 600);
    }

    public static boolean isRetryable(int statusCode) {
        return statusCode == 429 || HttpStatusCode.isServerError(statusCode) && statusCode != 501;
    }

    private static boolean isBetween(int min, int n, int maxExclusive) {
        return min <= n && n < maxExclusive;
    }
}

