/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * BatchCheckSingleResult
 */
@JsonPropertyOrder({BatchCheckSingleResult.JSON_PROPERTY_ALLOWED, BatchCheckSingleResult.JSON_PROPERTY_ERROR})
public class BatchCheckSingleResult {
    public static final String JSON_PROPERTY_ALLOWED = "allowed";
    private Boolean allowed;

    public static final String JSON_PROPERTY_ERROR = "error";
    private CheckError error;

    public BatchCheckSingleResult() {}

    public BatchCheckSingleResult allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    /**
     * Get allowed
     * @return allowed
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_ALLOWED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAllowed() {
        return allowed;
    }

    @JsonProperty(JSON_PROPERTY_ALLOWED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public BatchCheckSingleResult error(CheckError error) {
        this.error = error;
        return this;
    }

    /**
     * Get error
     * @return error
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public CheckError getError() {
        return error;
    }

    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setError(CheckError error) {
        this.error = error;
    }

    /**
     * Return true if this BatchCheckSingleResult object is equal to o.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BatchCheckSingleResult batchCheckSingleResult = (BatchCheckSingleResult) o;
        return Objects.equals(this.allowed, batchCheckSingleResult.allowed)
                && Objects.equals(this.error, batchCheckSingleResult.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(allowed, error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCheckSingleResult {\n");
        sb.append("    allowed: ").append(toIndentedString(allowed)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    /**
     * Convert the instance into URL query string.
     *
     * @return URL query string
     */
    public String toUrlQueryString() {
        return toUrlQueryString(null);
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix prefix of the query string
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            // style=form, explode=true, e.g. /pet?name=cat&type=manx
            prefix = "";
        } else {
            // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }

        StringJoiner joiner = new StringJoiner("&");

        // add `allowed` to the URL query string
        if (getAllowed() != null) {
            joiner.add(String.format(
                    "%sallowed%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getAllowed()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `error` to the URL query string
        if (getError() != null) {
            joiner.add(getError().toUrlQueryString(prefix + "error" + suffix));
        }

        return joiner.toString();
    }
}
