/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * CheckError
 */
@JsonPropertyOrder({
    CheckError.JSON_PROPERTY_INPUT_ERROR,
    CheckError.JSON_PROPERTY_INTERNAL_ERROR,
    CheckError.JSON_PROPERTY_MESSAGE
})
public class CheckError {
    public static final String JSON_PROPERTY_INPUT_ERROR = "input_error";
    private ErrorCode inputError = ErrorCode.NO_ERROR;

    public static final String JSON_PROPERTY_INTERNAL_ERROR = "internal_error";
    private InternalErrorCode internalError = InternalErrorCode.NO_INTERNAL_ERROR;

    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public CheckError() {}

    public CheckError inputError(ErrorCode inputError) {
        this.inputError = inputError;
        return this;
    }

    /**
     * Get inputError
     * @return inputError
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_INPUT_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public ErrorCode getInputError() {
        return inputError;
    }

    @JsonProperty(JSON_PROPERTY_INPUT_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInputError(ErrorCode inputError) {
        this.inputError = inputError;
    }

    public CheckError internalError(InternalErrorCode internalError) {
        this.internalError = internalError;
        return this;
    }

    /**
     * Get internalError
     * @return internalError
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_INTERNAL_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public InternalErrorCode getInternalError() {
        return internalError;
    }

    @JsonProperty(JSON_PROPERTY_INTERNAL_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInternalError(InternalErrorCode internalError) {
        this.internalError = internalError;
    }

    public CheckError message(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get message
     * @return message
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return message;
    }

    @JsonProperty(JSON_PROPERTY_MESSAGE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * Return true if this CheckError object is equal to o.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CheckError checkError = (CheckError) o;
        return Objects.equals(this.inputError, checkError.inputError)
                && Objects.equals(this.internalError, checkError.internalError)
                && Objects.equals(this.message, checkError.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(inputError, internalError, message);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckError {\n");
        sb.append("    inputError: ").append(toIndentedString(inputError)).append("\n");
        sb.append("    internalError: ").append(toIndentedString(internalError)).append("\n");
        sb.append("    message: ").append(toIndentedString(message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    /**
     * Convert the instance into URL query string.
     *
     * @return URL query string
     */
    public String toUrlQueryString() {
        return toUrlQueryString(null);
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix prefix of the query string
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            // style=form, explode=true, e.g. /pet?name=cat&type=manx
            prefix = "";
        } else {
            // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }

        StringJoiner joiner = new StringJoiner("&");

        // add `input_error` to the URL query string
        if (getInputError() != null) {
            joiner.add(String.format(
                    "%sinput_error%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getInputError()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `internal_error` to the URL query string
        if (getInternalError() != null) {
            joiner.add(String.format(
                    "%sinternal_error%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getInternalError()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `message` to the URL query string
        if (getMessage() != null) {
            joiner.add(String.format(
                    "%smessage%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getMessage()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        return joiner.toString();
    }
}
