/*
 * OpenFGA
 * A high performance and flexible authorization/permission engine built for developers and inspired by Google Zanzibar.
 *
 * The version of the OpenAPI document: 1.x
 * Contact: community@openfga.dev
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

/**
 * ConditionParamTypeRef
 */
@JsonPropertyOrder({ConditionParamTypeRef.JSON_PROPERTY_TYPE_NAME, ConditionParamTypeRef.JSON_PROPERTY_GENERIC_TYPES})
public class ConditionParamTypeRef {
    public static final String JSON_PROPERTY_TYPE_NAME = "type_name";
    private TypeName typeName = TypeName.UNSPECIFIED;

    public static final String JSON_PROPERTY_GENERIC_TYPES = "generic_types";
    private List<ConditionParamTypeRef> genericTypes = new ArrayList<>();

    public ConditionParamTypeRef() {}

    public ConditionParamTypeRef typeName(TypeName typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get typeName
     * @return typeName
     **/
    @javax.annotation.Nonnull
    @JsonProperty(JSON_PROPERTY_TYPE_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public TypeName getTypeName() {
        return typeName;
    }

    @JsonProperty(JSON_PROPERTY_TYPE_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setTypeName(TypeName typeName) {
        this.typeName = typeName;
    }

    public ConditionParamTypeRef genericTypes(List<ConditionParamTypeRef> genericTypes) {
        this.genericTypes = genericTypes;
        return this;
    }

    public ConditionParamTypeRef addGenericTypesItem(ConditionParamTypeRef genericTypesItem) {
        if (this.genericTypes == null) {
            this.genericTypes = new ArrayList<>();
        }
        this.genericTypes.add(genericTypesItem);
        return this;
    }

    /**
     * Get genericTypes
     * @return genericTypes
     **/
    @javax.annotation.Nullable
    @JsonProperty(JSON_PROPERTY_GENERIC_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public List<ConditionParamTypeRef> getGenericTypes() {
        return genericTypes;
    }

    @JsonProperty(JSON_PROPERTY_GENERIC_TYPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGenericTypes(List<ConditionParamTypeRef> genericTypes) {
        this.genericTypes = genericTypes;
    }

    /**
     * Return true if this ConditionParamTypeRef object is equal to o.
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConditionParamTypeRef conditionParamTypeRef = (ConditionParamTypeRef) o;
        return Objects.equals(this.typeName, conditionParamTypeRef.typeName)
                && Objects.equals(this.genericTypes, conditionParamTypeRef.genericTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(typeName, genericTypes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionParamTypeRef {\n");
        sb.append("    typeName: ").append(toIndentedString(typeName)).append("\n");
        sb.append("    genericTypes: ").append(toIndentedString(genericTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    /**
     * Convert the instance into URL query string.
     *
     * @return URL query string
     */
    public String toUrlQueryString() {
        return toUrlQueryString(null);
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix prefix of the query string
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            // style=form, explode=true, e.g. /pet?name=cat&type=manx
            prefix = "";
        } else {
            // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }

        StringJoiner joiner = new StringJoiner("&");

        // add `type_name` to the URL query string
        if (getTypeName() != null) {
            joiner.add(String.format(
                    "%stype_name%s=%s",
                    prefix,
                    suffix,
                    URLEncoder.encode(String.valueOf(getTypeName()), StandardCharsets.UTF_8)
                            .replaceAll("\\+", "%20")));
        }

        // add `generic_types` to the URL query string
        if (getGenericTypes() != null) {
            for (int i = 0; i < getGenericTypes().size(); i++) {
                if (getGenericTypes().get(i) != null) {
                    joiner.add(getGenericTypes()
                            .get(i)
                            .toUrlQueryString(String.format(
                                    "%sgeneric_types%s%s",
                                    prefix,
                                    suffix,
                                    "".equals(suffix)
                                            ? ""
                                            : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
                }
            }
        }

        return joiner.toString();
    }
}
