/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api;

import dev.openfga.sdk.api.auth.OAuth2Client;
import dev.openfga.sdk.api.client.ApiClient;
import dev.openfga.sdk.api.client.ApiResponse;
import dev.openfga.sdk.api.client.HttpRequestAttempt;
import dev.openfga.sdk.api.configuration.Configuration;
import dev.openfga.sdk.api.configuration.ConfigurationOverride;
import dev.openfga.sdk.api.configuration.CredentialsMethod;
import dev.openfga.sdk.api.model.BatchCheckRequest;
import dev.openfga.sdk.api.model.BatchCheckResponse;
import dev.openfga.sdk.api.model.CheckRequest;
import dev.openfga.sdk.api.model.CheckResponse;
import dev.openfga.sdk.api.model.CreateStoreRequest;
import dev.openfga.sdk.api.model.CreateStoreResponse;
import dev.openfga.sdk.api.model.ExpandRequest;
import dev.openfga.sdk.api.model.ExpandResponse;
import dev.openfga.sdk.api.model.GetStoreResponse;
import dev.openfga.sdk.api.model.ListObjectsRequest;
import dev.openfga.sdk.api.model.ListObjectsResponse;
import dev.openfga.sdk.api.model.ListStoresResponse;
import dev.openfga.sdk.api.model.ListUsersRequest;
import dev.openfga.sdk.api.model.ListUsersResponse;
import dev.openfga.sdk.api.model.ReadAssertionsResponse;
import dev.openfga.sdk.api.model.ReadAuthorizationModelResponse;
import dev.openfga.sdk.api.model.ReadAuthorizationModelsResponse;
import dev.openfga.sdk.api.model.ReadChangesResponse;
import dev.openfga.sdk.api.model.ReadRequest;
import dev.openfga.sdk.api.model.ReadResponse;
import dev.openfga.sdk.api.model.WriteAssertionsRequest;
import dev.openfga.sdk.api.model.WriteAuthorizationModelRequest;
import dev.openfga.sdk.api.model.WriteAuthorizationModelResponse;
import dev.openfga.sdk.api.model.WriteRequest;
import dev.openfga.sdk.errors.ApiException;
import dev.openfga.sdk.errors.FgaInvalidParameterException;
import dev.openfga.sdk.telemetry.Attribute;
import dev.openfga.sdk.telemetry.Attributes;
import dev.openfga.sdk.telemetry.Telemetry;
import dev.openfga.sdk.util.Pair;
import dev.openfga.sdk.util.StringUtil;
import dev.openfga.sdk.util.Validation;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OpenFgaApi {
    private final Configuration configuration;
    private final ApiClient apiClient;
    private final OAuth2Client oAuth2Client;
    private final Telemetry telemetry;

    public OpenFgaApi(Configuration configuration) throws FgaInvalidParameterException {
        this(configuration, new ApiClient());
    }

    public OpenFgaApi(Configuration configuration, ApiClient apiClient) throws FgaInvalidParameterException {
        this.apiClient = apiClient;
        this.configuration = configuration;
        this.telemetry = new Telemetry(this.configuration);
        this.oAuth2Client = configuration.getCredentials().getCredentialsMethod() == CredentialsMethod.CLIENT_CREDENTIALS ? new OAuth2Client(configuration, apiClient) : null;
        Map<String, String> defaultHeaders = configuration.getDefaultHeaders();
        if (defaultHeaders != null) {
            apiClient.addRequestInterceptor(httpRequest -> defaultHeaders.forEach(httpRequest::setHeader));
        }
    }

    public CompletableFuture<ApiResponse<BatchCheckResponse>> batchCheck(String storeId, BatchCheckRequest body) throws ApiException, FgaInvalidParameterException {
        return this.batchCheck(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<BatchCheckResponse>> batchCheck(String storeId, BatchCheckRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.batchCheck(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<BatchCheckResponse>> batchCheck(String storeId, BatchCheckRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "batchCheck");
        Validation.assertParamExists(body, "body", "batchCheck");
        String path = "/stores/{store_id}/batch-check".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "BatchCheck");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<BatchCheckResponse>(request, "batchCheck", BatchCheckResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<CheckResponse>> check(String storeId, CheckRequest body) throws ApiException, FgaInvalidParameterException {
        return this.check(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<CheckResponse>> check(String storeId, CheckRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.check(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<CheckResponse>> check(String storeId, CheckRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "check");
        Validation.assertParamExists(body, "body", "check");
        String path = "/stores/{store_id}/check".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Check");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<CheckResponse>(request, "check", CheckResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(CreateStoreRequest body) throws ApiException, FgaInvalidParameterException {
        return this.createStore(body, this.configuration);
    }

    public CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(CreateStoreRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.createStore(body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<CreateStoreResponse>> createStore(CreateStoreRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(body, "body", "createStore");
        String path = "/stores";
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "CreateStore");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<CreateStoreResponse>(request, "createStore", CreateStoreResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<Void>> deleteStore(String storeId) throws ApiException, FgaInvalidParameterException {
        return this.deleteStore(storeId, this.configuration);
    }

    public CompletableFuture<ApiResponse<Void>> deleteStore(String storeId, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.deleteStore(storeId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Void>> deleteStore(String storeId, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "deleteStore");
        String path = "/stores/{store_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "DeleteStore");
        try {
            HttpRequest request = this.buildHttpRequest("DELETE", path, configuration);
            return new HttpRequestAttempt<Void>(request, "deleteStore", Void.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ExpandResponse>> expand(String storeId, ExpandRequest body) throws ApiException, FgaInvalidParameterException {
        return this.expand(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<ExpandResponse>> expand(String storeId, ExpandRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.expand(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ExpandResponse>> expand(String storeId, ExpandRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "expand");
        Validation.assertParamExists(body, "body", "expand");
        String path = "/stores/{store_id}/expand".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Expand");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<ExpandResponse>(request, "expand", ExpandResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<GetStoreResponse>> getStore(String storeId) throws ApiException, FgaInvalidParameterException {
        return this.getStore(storeId, this.configuration);
    }

    public CompletableFuture<ApiResponse<GetStoreResponse>> getStore(String storeId, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.getStore(storeId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<GetStoreResponse>> getStore(String storeId, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "getStore");
        String path = "/stores/{store_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "GetStore");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<GetStoreResponse>(request, "getStore", GetStoreResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(String storeId, ListObjectsRequest body) throws ApiException, FgaInvalidParameterException {
        return this.listObjects(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(String storeId, ListObjectsRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.listObjects(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListObjectsResponse>> listObjects(String storeId, ListObjectsRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "listObjects");
        Validation.assertParamExists(body, "body", "listObjects");
        String path = "/stores/{store_id}/list-objects".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListObjects");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<ListObjectsResponse>(request, "listObjects", ListObjectsResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ListStoresResponse>> listStores(Integer pageSize, String continuationToken) throws ApiException, FgaInvalidParameterException {
        return this.listStores(pageSize, continuationToken, this.configuration);
    }

    public CompletableFuture<ApiResponse<ListStoresResponse>> listStores(Integer pageSize, String continuationToken, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.listStores(pageSize, continuationToken, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListStoresResponse>> listStores(Integer pageSize, String continuationToken, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        String path = "/stores";
        path = this.pathWithParams(path, "page_size", pageSize, "continuation_token", continuationToken);
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListStores");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<ListStoresResponse>(request, "listStores", ListStoresResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(String storeId, ListUsersRequest body) throws ApiException, FgaInvalidParameterException {
        return this.listUsers(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(String storeId, ListUsersRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.listUsers(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ListUsersResponse>> listUsers(String storeId, ListUsersRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "listUsers");
        Validation.assertParamExists(body, "body", "listUsers");
        String path = "/stores/{store_id}/list-users".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ListUsers");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<ListUsersResponse>(request, "listUsers", ListUsersResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ReadResponse>> read(String storeId, ReadRequest body) throws ApiException, FgaInvalidParameterException {
        return this.read(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<ReadResponse>> read(String storeId, ReadRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.read(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadResponse>> read(String storeId, ReadRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "read");
        Validation.assertParamExists(body, "body", "read");
        String path = "/stores/{store_id}/read".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Read");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<ReadResponse>(request, "read", ReadResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(String storeId, String authorizationModelId) throws ApiException, FgaInvalidParameterException {
        return this.readAssertions(storeId, authorizationModelId, this.configuration);
    }

    public CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(String storeId, String authorizationModelId, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.readAssertions(storeId, authorizationModelId, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAssertionsResponse>> readAssertions(String storeId, String authorizationModelId, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "readAssertions");
        Validation.assertParamExists(authorizationModelId, "authorizationModelId", "readAssertions");
        String path = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("authorizationModelId", authorizationModelId);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAssertions");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<ReadAssertionsResponse>(request, "readAssertions", ReadAssertionsResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(String storeId, String id) throws ApiException, FgaInvalidParameterException {
        return this.readAuthorizationModel(storeId, id, this.configuration);
    }

    public CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(String storeId, String id, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.readAuthorizationModel(storeId, id, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAuthorizationModelResponse>> readAuthorizationModel(String storeId, String id, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "readAuthorizationModel");
        Validation.assertParamExists(id, "id", "readAuthorizationModel");
        String path = "/stores/{store_id}/authorization-models/{id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{id}", ApiClient.urlEncode(id.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("id", id);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAuthorizationModel");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<ReadAuthorizationModelResponse>(request, "readAuthorizationModel", ReadAuthorizationModelResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(String storeId, Integer pageSize, String continuationToken) throws ApiException, FgaInvalidParameterException {
        return this.readAuthorizationModels(storeId, pageSize, continuationToken, this.configuration);
    }

    public CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(String storeId, Integer pageSize, String continuationToken, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.readAuthorizationModels(storeId, pageSize, continuationToken, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadAuthorizationModelsResponse>> readAuthorizationModels(String storeId, Integer pageSize, String continuationToken, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "readAuthorizationModels");
        String path = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        path = this.pathWithParams(path, "page_size", pageSize, "continuation_token", continuationToken);
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadAuthorizationModels");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<ReadAuthorizationModelsResponse>(request, "readAuthorizationModels", ReadAuthorizationModelsResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(String storeId, String type, Integer pageSize, String continuationToken, OffsetDateTime startTime) throws ApiException, FgaInvalidParameterException {
        return this.readChanges(storeId, type, pageSize, continuationToken, startTime, this.configuration);
    }

    public CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(String storeId, String type, Integer pageSize, String continuationToken, OffsetDateTime startTime, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.readChanges(storeId, type, pageSize, continuationToken, startTime, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<ReadChangesResponse>> readChanges(String storeId, String type, Integer pageSize, String continuationToken, OffsetDateTime startTime, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "readChanges");
        String path = "/stores/{store_id}/changes".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        path = this.pathWithParams(path, "type", type, "page_size", pageSize, "continuation_token", continuationToken, "start_time", startTime);
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "ReadChanges");
        try {
            HttpRequest request = this.buildHttpRequest("GET", path, configuration);
            return new HttpRequestAttempt<ReadChangesResponse>(request, "readChanges", ReadChangesResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<Object>> write(String storeId, WriteRequest body) throws ApiException, FgaInvalidParameterException {
        return this.write(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<Object>> write(String storeId, WriteRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.write(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Object>> write(String storeId, WriteRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "write");
        Validation.assertParamExists(body, "body", "write");
        String path = "/stores/{store_id}/write".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "Write");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<Object>(request, "write", Object.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<Void>> writeAssertions(String storeId, String authorizationModelId, WriteAssertionsRequest body) throws ApiException, FgaInvalidParameterException {
        return this.writeAssertions(storeId, authorizationModelId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<Void>> writeAssertions(String storeId, String authorizationModelId, WriteAssertionsRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.writeAssertions(storeId, authorizationModelId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<Void>> writeAssertions(String storeId, String authorizationModelId, WriteAssertionsRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "writeAssertions");
        Validation.assertParamExists(authorizationModelId, "authorizationModelId", "writeAssertions");
        Validation.assertParamExists(body, "body", "writeAssertions");
        String path = "/stores/{store_id}/assertions/{authorization_model_id}".replace("{store_id}", ApiClient.urlEncode(storeId.toString())).replace("{authorization_model_id}", ApiClient.urlEncode(authorizationModelId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("authorizationModelId", authorizationModelId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "WriteAssertions");
        try {
            HttpRequest request = this.buildHttpRequest("PUT", path, body, configuration);
            return new HttpRequestAttempt<Void>(request, "writeAssertions", Void.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(String storeId, WriteAuthorizationModelRequest body) throws ApiException, FgaInvalidParameterException {
        return this.writeAuthorizationModel(storeId, body, this.configuration);
    }

    public CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(String storeId, WriteAuthorizationModelRequest body, ConfigurationOverride configurationOverride) throws ApiException, FgaInvalidParameterException {
        return this.writeAuthorizationModel(storeId, body, this.configuration.override(configurationOverride));
    }

    private CompletableFuture<ApiResponse<WriteAuthorizationModelResponse>> writeAuthorizationModel(String storeId, WriteAuthorizationModelRequest body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        Validation.assertParamExists(storeId, "storeId", "writeAuthorizationModel");
        Validation.assertParamExists(body, "body", "writeAuthorizationModel");
        String path = "/stores/{store_id}/authorization-models".replace("{store_id}", ApiClient.urlEncode(storeId.toString()));
        HashMap<String, Object> methodParameters = new HashMap<String, Object>();
        methodParameters.put("storeId", storeId);
        methodParameters.put("body", body);
        Map<Attribute, String> telemetryAttributes = this.buildTelemetryAttributes(methodParameters);
        telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_METHOD, "WriteAuthorizationModel");
        try {
            HttpRequest request = this.buildHttpRequest("POST", path, body, configuration);
            return new HttpRequestAttempt<WriteAuthorizationModelResponse>(request, "writeAuthorizationModel", WriteAuthorizationModelResponse.class, this.apiClient, configuration).addTelemetryAttributes(telemetryAttributes).attemptHttpRequest();
        }
        catch (ApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Map<Attribute, String> buildTelemetryAttributes(Map<String, Object> attributes) {
        HashMap<Attribute, String> telemetryAttributes = new HashMap<Attribute, String>();
        Object storeId = attributes.get("storeId");
        Object authorizationModelId = attributes.get("authorizationModelId");
        Object body = attributes.get("body");
        if (storeId != null) {
            telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_STORE_ID, storeId.toString());
        }
        if (authorizationModelId != null) {
            telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, authorizationModelId.toString());
        }
        if (body != null) {
            BatchCheckRequest batchCheckRequest;
            WriteRequest writeRequest;
            ListUsersRequest listUsersRequest;
            ListObjectsRequest listObjectsRequest;
            ExpandRequest expandRequest;
            if (body instanceof CheckRequest) {
                CheckRequest checkRequest = (CheckRequest)body;
                if (checkRequest.getTupleKey() != null && !StringUtil.isNullOrWhitespace(checkRequest.getTupleKey().getUser())) {
                    telemetryAttributes.put(Attributes.FGA_CLIENT_USER, checkRequest.getTupleKey().getUser());
                }
                if (!StringUtil.isNullOrWhitespace(checkRequest.getAuthorizationModelId())) {
                    telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, checkRequest.getAuthorizationModelId());
                }
            }
            if (body instanceof ExpandRequest && !StringUtil.isNullOrWhitespace((expandRequest = (ExpandRequest)body).getAuthorizationModelId())) {
                telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, expandRequest.getAuthorizationModelId());
            }
            if (body instanceof ListObjectsRequest && !StringUtil.isNullOrWhitespace((listObjectsRequest = (ListObjectsRequest)body).getAuthorizationModelId())) {
                telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, listObjectsRequest.getAuthorizationModelId());
            }
            if (body instanceof ListUsersRequest && !StringUtil.isNullOrWhitespace((listUsersRequest = (ListUsersRequest)body).getAuthorizationModelId())) {
                telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, listUsersRequest.getAuthorizationModelId());
            }
            if (body instanceof WriteRequest && !StringUtil.isNullOrWhitespace((writeRequest = (WriteRequest)body).getAuthorizationModelId())) {
                telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_MODEL_ID, writeRequest.getAuthorizationModelId());
            }
            if (body instanceof BatchCheckRequest && (batchCheckRequest = (BatchCheckRequest)body).getChecks() != null) {
                telemetryAttributes.put(Attributes.FGA_CLIENT_REQUEST_BATCH_CHECK_SIZE, String.valueOf(batchCheckRequest.getChecks().size()));
            }
        }
        return telemetryAttributes;
    }

    private HttpRequest buildHttpRequest(String method, String path, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        return this.buildHttpRequestWithPublisher(method, path, HttpRequest.BodyPublishers.noBody(), configuration);
    }

    private <T> HttpRequest buildHttpRequest(String method, String path, T body, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        try {
            byte[] localVarPostBody = this.apiClient.getObjectMapper().writeValueAsBytes(body);
            HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofByteArray(localVarPostBody);
            return this.buildHttpRequestWithPublisher(method, path, bodyPublisher, configuration);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    private HttpRequest buildHttpRequestWithPublisher(String method, String path, HttpRequest.BodyPublisher bodyPublisher, Configuration configuration) throws ApiException, FgaInvalidParameterException {
        configuration.assertValid();
        HttpRequest.Builder httpRequest = HttpRequest.newBuilder();
        httpRequest.uri(URI.create(configuration.getApiUrl() + path));
        httpRequest.header("Content-Type", "application/json");
        httpRequest.header("Accept", "application/json");
        if (configuration.getCredentials().getCredentialsMethod() != CredentialsMethod.NONE) {
            String accessToken = this.getAccessToken(configuration);
            httpRequest.header("Authorization", "Bearer " + accessToken);
        }
        if (configuration.getUserAgent() != null) {
            httpRequest.header("User-Agent", configuration.getUserAgent());
        }
        if (configuration.getDefaultHeaders() != null) {
            configuration.getDefaultHeaders().forEach(httpRequest::header);
        }
        httpRequest.method(method, bodyPublisher);
        Duration readTimeout = configuration.getReadTimeout();
        if (readTimeout != null) {
            httpRequest.timeout(readTimeout);
        }
        if (this.apiClient.getRequestInterceptor() != null) {
            this.apiClient.getRequestInterceptor().accept(httpRequest);
        }
        return httpRequest.build();
    }

    private String pathWithParams(String basePath, Object ... params) {
        StringBuilder path = new StringBuilder().append(basePath);
        Stream.Builder paramStream = Stream.builder();
        for (int i = 0; i < params.length - 1; i += 2) {
            if (params[i] == null || params[i + 1] == null) continue;
            Pair.of(params[i].toString(), params[i + 1].toString()).map(Pair::asQueryStringPair).ifPresent(paramStream::add);
        }
        String parameters = paramStream.build().collect(Collectors.joining("&"));
        if (!StringUtil.isNullOrWhitespace(parameters)) {
            path.append("?").append(parameters);
        }
        return path.toString();
    }

    private String getAccessToken(Configuration configuration) throws ApiException {
        CredentialsMethod credentialsMethod = configuration.getCredentials().getCredentialsMethod();
        if (credentialsMethod == CredentialsMethod.API_TOKEN) {
            return configuration.getCredentials().getApiToken().getToken();
        }
        if (credentialsMethod == CredentialsMethod.CLIENT_CREDENTIALS) {
            try {
                return this.oAuth2Client.getAccessToken().get();
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        throw new IllegalStateException("Configuration is invalid.");
    }
}

