/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.auth;

import dev.openfga.sdk.util.StringUtil;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Random;

class AccessToken {
    private static final int TOKEN_EXPIRY_BUFFER_THRESHOLD_IN_SEC = 300;
    private static final int TOKEN_EXPIRY_JITTER_IN_SEC = 300;
    private Instant expiresAt;
    private final Random random = new Random();
    private String token;

    AccessToken() {
    }

    public boolean isValid() {
        if (StringUtil.isNullOrWhitespace(this.token)) {
            return false;
        }
        if (this.expiresAt == null) {
            return true;
        }
        Instant expiresWithLeeway = this.expiresAt.minusSeconds(300L).minusSeconds(this.random.nextInt(300)).truncatedTo(ChronoUnit.SECONDS);
        return Instant.now().truncatedTo(ChronoUnit.SECONDS).isBefore(expiresWithLeeway);
    }

    public String getToken() {
        return this.token;
    }

    public void setExpiresAt(Instant expiresAt) {
        if (expiresAt != null) {
            this.expiresAt = expiresAt.truncatedTo(ChronoUnit.SECONDS);
        }
    }

    public void setToken(String token) {
        this.token = token;
    }
}

