/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"object", "relation", "user"})
public class AssertionTupleKey {
    public static final String JSON_PROPERTY_OBJECT = "object";
    private String _object;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private String relation;
    public static final String JSON_PROPERTY_USER = "user";
    private String user;

    public AssertionTupleKey _object(String _object) {
        this._object = _object;
        return this;
    }

    @Nonnull
    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getObject() {
        return this._object;
    }

    @JsonProperty(value="object")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setObject(String _object) {
        this._object = _object;
    }

    public AssertionTupleKey relation(String relation) {
        this.relation = relation;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelation(String relation) {
        this.relation = relation;
    }

    public AssertionTupleKey user(String user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssertionTupleKey assertionTupleKey = (AssertionTupleKey)o;
        return Objects.equals(this._object, assertionTupleKey._object) && Objects.equals(this.relation, assertionTupleKey.relation) && Objects.equals(this.user, assertionTupleKey.user);
    }

    public int hashCode() {
        return Objects.hash(this._object, this.relation, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssertionTupleKey {\n");
        sb.append("    _object: ").append(this.toIndentedString(this._object)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getObject() != null) {
            joiner.add(String.format("%sobject%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getObject()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRelation() != null) {
            joiner.add(String.format("%srelation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRelation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUser() != null) {
            joiner.add(String.format("%suser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUser()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

