/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.CheckRequestTupleKey;
import dev.openfga.sdk.api.model.ContextualTupleKeys;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tuple_key", "contextual_tuples", "context", "correlation_id"})
public class BatchCheckItem {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    private CheckRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    private ContextualTupleKeys contextualTuples;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    private Object context;
    public static final String JSON_PROPERTY_CORRELATION_ID = "correlation_id";
    private String correlationId;

    public BatchCheckItem tupleKey(CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CheckRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public BatchCheckItem contextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public BatchCheckItem context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(Object context) {
        this.context = context;
    }

    public BatchCheckItem correlationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="correlation_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCorrelationId() {
        return this.correlationId;
    }

    @JsonProperty(value="correlation_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchCheckItem batchCheckItem = (BatchCheckItem)o;
        return Objects.equals(this.tupleKey, batchCheckItem.tupleKey) && Objects.equals(this.contextualTuples, batchCheckItem.contextualTuples) && Objects.equals(this.context, batchCheckItem.context) && Objects.equals(this.correlationId, batchCheckItem.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.contextualTuples, this.context, this.correlationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCheckItem {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        if (this.getContext() != null) {
            joiner.add(String.format("%scontext%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getContext()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCorrelationId() != null) {
            joiner.add(String.format("%scorrelation_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCorrelationId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

