/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.BatchCheckItem;
import dev.openfga.sdk.api.model.ConsistencyPreference;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"checks", "authorization_model_id", "consistency"})
public class BatchCheckRequest {
    public static final String JSON_PROPERTY_CHECKS = "checks";
    private List<BatchCheckItem> checks = new ArrayList<BatchCheckItem>();
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;

    public BatchCheckRequest checks(List<BatchCheckItem> checks) {
        this.checks = checks;
        return this;
    }

    public BatchCheckRequest addChecksItem(BatchCheckItem checksItem) {
        if (this.checks == null) {
            this.checks = new ArrayList<BatchCheckItem>();
        }
        this.checks.add(checksItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<BatchCheckItem> getChecks() {
        return this.checks;
    }

    @JsonProperty(value="checks")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setChecks(List<BatchCheckItem> checks) {
        this.checks = checks;
    }

    public BatchCheckRequest authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public BatchCheckRequest consistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchCheckRequest batchCheckRequest = (BatchCheckRequest)o;
        return Objects.equals(this.checks, batchCheckRequest.checks) && Objects.equals(this.authorizationModelId, batchCheckRequest.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)batchCheckRequest.consistency);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checks, this.authorizationModelId, this.consistency});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCheckRequest {\n");
        sb.append("    checks: ").append(this.toIndentedString(this.checks)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getChecks() != null) {
            for (int i = 0; i < this.getChecks().size(); ++i) {
                if (this.getChecks().get(i) == null) continue;
                joiner.add(this.getChecks().get(i).toUrlQueryString(String.format("%schecks%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorizationModelId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConsistency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

