/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.ErrorCode;
import dev.openfga.sdk.api.model.InternalErrorCode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"input_error", "internal_error", "message"})
public class CheckError {
    public static final String JSON_PROPERTY_INPUT_ERROR = "input_error";
    private ErrorCode inputError = ErrorCode.NO_ERROR;
    public static final String JSON_PROPERTY_INTERNAL_ERROR = "internal_error";
    private InternalErrorCode internalError = InternalErrorCode.NO_INTERNAL_ERROR;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;

    public CheckError inputError(ErrorCode inputError) {
        this.inputError = inputError;
        return this;
    }

    @Nullable
    @JsonProperty(value="input_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrorCode getInputError() {
        return this.inputError;
    }

    @JsonProperty(value="input_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputError(ErrorCode inputError) {
        this.inputError = inputError;
    }

    public CheckError internalError(InternalErrorCode internalError) {
        this.internalError = internalError;
        return this;
    }

    @Nullable
    @JsonProperty(value="internal_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InternalErrorCode getInternalError() {
        return this.internalError;
    }

    @JsonProperty(value="internal_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInternalError(InternalErrorCode internalError) {
        this.internalError = internalError;
    }

    public CheckError message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckError checkError = (CheckError)o;
        return Objects.equals((Object)this.inputError, (Object)checkError.inputError) && Objects.equals((Object)this.internalError, (Object)checkError.internalError) && Objects.equals(this.message, checkError.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputError, this.internalError, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckError {\n");
        sb.append("    inputError: ").append(this.toIndentedString((Object)this.inputError)).append("\n");
        sb.append("    internalError: ").append(this.toIndentedString((Object)this.internalError)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInputError() != null) {
            joiner.add(String.format("%sinput_error%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getInputError()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInternalError() != null) {
            joiner.add(String.format("%sinternal_error%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getInternalError()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getMessage() != null) {
            joiner.add(String.format("%smessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getMessage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

