/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.ConsistencyPreference;
import dev.openfga.sdk.api.model.ContextualTupleKeys;
import dev.openfga.sdk.api.model.ExpandRequestTupleKey;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"tuple_key", "authorization_model_id", "consistency", "contextual_tuples"})
public class ExpandRequest {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    private ExpandRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    private String authorizationModelId;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    private ContextualTupleKeys contextualTuples;

    public ExpandRequest tupleKey(ExpandRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExpandRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(ExpandRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public ExpandRequest authorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ExpandRequest consistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public ExpandRequest contextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandRequest expandRequest = (ExpandRequest)o;
        return Objects.equals(this.tupleKey, expandRequest.tupleKey) && Objects.equals(this.authorizationModelId, expandRequest.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)expandRequest.consistency) && Objects.equals(this.contextualTuples, expandRequest.contextualTuples);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.authorizationModelId, this.consistency, this.contextualTuples});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandRequest {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format("%sauthorization_model_id%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getAuthorizationModelId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format("%sconsistency%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getConsistency()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        return joiner.toString();
    }
}

