/*
 * Decompiled with CFR 0.152.
 */
package dev.openfga.sdk.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import dev.openfga.sdk.api.model.RelationMetadata;
import dev.openfga.sdk.api.model.SourceInfo;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"relations", "module", "source_info"})
public class Metadata {
    public static final String JSON_PROPERTY_RELATIONS = "relations";
    private Map<String, RelationMetadata> relations = new HashMap<String, RelationMetadata>();
    public static final String JSON_PROPERTY_MODULE = "module";
    private String module;
    public static final String JSON_PROPERTY_SOURCE_INFO = "source_info";
    private SourceInfo sourceInfo;

    public Metadata relations(Map<String, RelationMetadata> relations) {
        this.relations = relations;
        return this;
    }

    public Metadata putRelationsItem(String key, RelationMetadata relationsItem) {
        if (this.relations == null) {
            this.relations = new HashMap<String, RelationMetadata>();
        }
        this.relations.put(key, relationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="relations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, RelationMetadata> getRelations() {
        return this.relations;
    }

    @JsonProperty(value="relations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelations(Map<String, RelationMetadata> relations) {
        this.relations = relations;
    }

    public Metadata module(String module) {
        this.module = module;
        return this;
    }

    @Nullable
    @JsonProperty(value="module")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="module")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModule(String module) {
        this.module = module;
    }

    public Metadata sourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JsonProperty(value="source_info")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceInfo(SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.relations, metadata.relations) && Objects.equals(this.module, metadata.module) && Objects.equals(this.sourceInfo, metadata.sourceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.relations, this.module, this.sourceInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Metadata {\n");
        sb.append("    relations: ").append(this.toIndentedString(this.relations)).append("\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    sourceInfo: ").append(this.toIndentedString(this.sourceInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRelations() != null) {
            for (String _key : this.getRelations().keySet()) {
                if (this.getRelations().get(_key) == null) continue;
                joiner.add(this.getRelations().get(_key).toUrlQueryString(String.format("%srelations%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        if (this.getModule() != null) {
            joiner.add(String.format("%smodule%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getModule()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSourceInfo() != null) {
            joiner.add(this.getSourceInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_SOURCE_INFO + suffix));
        }
        return joiner.toString();
    }
}

